/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleDB
extends BaseDB {
    private static final String[] _ORACLE = new String[]{"--", "1", "0", "to_date('1970-01-01 00:00:00','YYYY-MM-DD HH24:MI:SS')", "sysdate", " blob", " blob", " number(1, 0)", " timestamp", " number(30,20)", " number(30,0)", " number(30,0)", " varchar2(4000)", " clob", " varchar2", "", "commit"};
    private static final boolean _SUPPORTS_INLINE_DISTINCT = false;
    private static OracleDB _instance = new OracleDB();
    private static Pattern _varcharPattern = Pattern.compile("VARCHAR\\((\\d+)\\)");

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this._preBuildSQL(template);
        template = this._postBuildSQL(template);
        return template;
    }

    @Override
    public void buildSQLFile(String sqlDir, String fileName) throws IOException {
        String oracle = this.buildTemplate(sqlDir, fileName);
        oracle = this._preBuildSQL(oracle);
        StringBundler imageSB = new StringBundler();
        StringBundler journalArticleSB = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(oracle));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("insert into Image")) {
                    this._convertToOracleCSV(line, imageSB);
                    continue;
                }
                if (!line.startsWith("insert into JournalArticle (")) continue;
                this._convertToOracleCSV(line, journalArticleSB);
            }
        }
        if (imageSB.length() > 0) {
            FileUtil.write((String)(sqlDir + "/" + fileName + "/" + fileName + "-oracle-image.csv"), (String)imageSB.toString());
        }
        if (journalArticleSB.length() > 0) {
            FileUtil.write((String)(sqlDir + "/" + fileName + "/" + fileName + "-oracle-journalarticle.csv"), (String)journalArticleSB.toString());
        }
        oracle = this._postBuildSQL(oracle);
        FileUtil.write((String)(sqlDir + "/" + fileName + "/" + fileName + "-oracle.sql"), (String)oracle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> getIndexes(Connection con) throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            StringBundler sb = new StringBundler(3);
            sb.append("select index_name, table_name, uniqueness from ");
            sb.append("user_indexes where index_name like 'LIFERAY_%' or ");
            sb.append("index_name like 'IX_%'");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("index_name");
                String tableName = rs.getString("table_name");
                String uniqueness = rs.getString("uniqueness");
                boolean unique = true;
                if (StringUtil.equalsIgnoreCase((String)uniqueness, (String)"NONUNIQUE")) {
                    unique = false;
                }
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(null, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
        return indexes;
    }

    @Override
    public boolean isSupportsInlineDistinct() {
        return false;
    }

    protected OracleDB() {
        super("oracle");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(13);
        sb.append("drop user &1 cascade;\n");
        sb.append("create user &1 identified by &2;\n");
        sb.append("grant connect,resource to &1;\n");
        if (population != 0) {
            sb.append("connect &1/&2;\n");
            sb.append("set define off;\n");
            sb.append("\n");
            sb.append(this.getCreateTablesContent(sqlDir, suffix));
            sb.append("\n\n");
            sb.append(this.readFile(sqlDir + "/indexes/indexes-oracle.sql"));
            sb.append("\n\n");
            sb.append(this.readFile(sqlDir + "/sequences/sequences-oracle.sql"));
            sb.append("\n");
        }
        sb.append("quit");
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "oracle";
    }

    @Override
    protected String[] getTemplate() {
        return _ORACLE;
    }

    @Override
    protected String replaceTemplate(String template, String[] actual) {
        Matcher matcher = _varcharPattern.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int size = GetterUtil.getInteger((String)matcher.group(1));
            if (size > 4000) {
                size = 4000;
            }
            matcher.appendReplacement(sb, "VARCHAR2(" + size + " CHAR)");
        }
        matcher.appendTail(sb);
        template = sb.toString();
        return super.replaceTemplate(template, actual);
    }

    @Override
    protected String reword(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] template;
                if (line.startsWith("alter_column_name ")) {
                    template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ rename column @old-column@ to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_column_type ")) {
                    template = this.buildColumnTypeTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ modify @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_table_name ")) {
                    template = this.buildTableNameTokens(line);
                    line = StringUtil.replace((String)"alter table @old-table@ rename to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
                } else if (line.contains("drop index")) {
                    String[] tokens = StringUtil.split((String)line, (char)' ');
                    line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
                }
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    private void _convertToOracleCSV(String line, StringBundler sb) {
        int x = line.indexOf("values (");
        int y = line.lastIndexOf(");");
        line = line.substring(x + 8, y);
        line = StringUtil.replace((String)line, (String)"sysdate, ", (String)"20050101, ");
        sb.append(line);
        sb.append("\n");
    }

    private String _postBuildSQL(String template) throws IOException {
        template = this.removeLongInserts(template);
        template = StringUtil.replace((String)template, (String)"\\n", (String)"'||CHR(10)||'");
        return template;
    }

    private String _preBuildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String[])new String[]{"\\\\", "\\'", "\\\""}, (String[])new String[]{"\\", "''", "\""});
        return template;
    }
}

