/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class FirebirdDB
extends BaseDB {
    private static final String[] _FIREBIRD = new String[]{"--", "1", "0", "'01/01/1970'", "current_timestamp", " blob", " blob", " smallint", " timestamp", " double precision", " integer", " int64", " varchar(4000)", " blob", " varchar", "", "commit"};
    private static FirebirdDB _instance = new FirebirdDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = this.removeInserts(template);
        template = this.removeNull(template);
        return template;
    }

    protected FirebirdDB() {
        super("firebird");
    }

    protected FirebirdDB(String type) {
        super(type);
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(7);
        sb.append("create database '");
        sb.append(databaseName);
        sb.append(".gdb' page_size 8192 user 'sysdba' password 'masterkey';\n");
        sb.append("connect '");
        sb.append(databaseName);
        sb.append(".gdb' user 'sysdba' password 'masterkey';\n");
        if (population != 0) {
            if (!sqlDir.endsWith("/WEB-INF/sql")) {
                sb.append(this.readSQL(sqlDir + "/portal" + suffix + "/portal" + suffix + "-firebird.sql", _FIREBIRD[0], ";\n"));
            } else {
                sb.append(this.readSQL(sqlDir + "/tables" + suffix + "/tables" + suffix + "-firebird.sql", _FIREBIRD[0], ";\n"));
            }
        }
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "firebird";
    }

    @Override
    protected String[] getTemplate() {
        return _FIREBIRD;
    }

    @Override
    protected String reword(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] template;
                if (line.startsWith("alter_column_name ")) {
                    template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ alter column \"@old-column@\" to \"@new-column@\";", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_column_type ")) {
                    template = this.buildColumnTypeTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ alter column \"@old-column@\" type @type@;", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.contains("drop index")) {
                    String[] tokens = StringUtil.split((String)line, (char)' ');
                    line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
                }
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

