/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;

public class DB2DB
extends BaseDB {
    private static final String[] _DB2 = new String[]{"--", "1", "0", "'1970-01-01-00.00.00.000000'", "current timestamp", " blob", " blob", " smallint", " timestamp", " double", " integer", " bigint", " varchar(750)", " clob", " varchar", " generated always as identity", "commit"};
    private static final boolean _SUPPORTS_ALTER_COLUMN_TYPE = false;
    private static final boolean _SUPPORTS_INLINE_DISTINCT = false;
    private static final boolean _SUPPORTS_SCROLLABLE_RESULTS = false;
    private static DB2DB _instance = new DB2DB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = this.removeLongInserts(template);
        template = this.removeNull(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        template = StringUtil.replace((String)template, (String)"\\n", (String)"'||CHR(10)||'");
        return template;
    }

    @Override
    public boolean isSupportsAlterColumnType() {
        return false;
    }

    @Override
    public boolean isSupportsInlineDistinct() {
        return false;
    }

    @Override
    public boolean isSupportsScrollableResults() {
        return false;
    }

    @Override
    public void runSQL(String template) throws IOException, SQLException {
        if (template.startsWith("alter_column_name ")) {
            String[] alterSqls;
            String sql = this.buildSQL(template);
            for (String alterSql : alterSqls = StringUtil.split((String)sql, (char)';')) {
                alterSql = StringUtil.trim((String)alterSql);
                this.runSQL(alterSql);
            }
        } else {
            super.runSQL(template);
        }
    }

    @Override
    public void runSQL(String[] templates) throws IOException, SQLException {
        super.runSQL(templates);
        this.reorgTables(templates);
    }

    protected DB2DB() {
        super("db2");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(14);
        sb.append("drop database ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("create database ");
        sb.append(databaseName);
        sb.append(" pagesize 8192;\n");
        if (population != 0) {
            sb.append("connect to ");
            sb.append(databaseName);
            sb.append(";\n");
            sb.append(this.getCreateTablesContent(sqlDir, suffix));
            sb.append("\n\n");
            sb.append(this.readFile(sqlDir + "/indexes/indexes-db2.sql"));
            sb.append("\n\n");
            sb.append(this.readFile(sqlDir + "/sequences/sequences-db2.sql"));
        }
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "db2";
    }

    @Override
    protected String[] getTemplate() {
        return _DB2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRequiresReorgTable(Connection con, String tableName) throws SQLException {
        boolean reorgTableRequired = false;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int numReorgRecAlters;
            StringBundler sb = new StringBundler(4);
            sb.append("select num_reorg_rec_alters from table(");
            sb.append("sysproc.admin_get_tab_info(current_schema, '");
            sb.append(StringUtil.toUpperCase((String)tableName));
            sb.append("')) where reorg_pending = 'Y'");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            if (rs.next() && (numReorgRecAlters = rs.getInt(1)) >= 1) {
                reorgTableRequired = true;
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(null, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
        return reorgTableRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reorgTable(Connection con, String tableName) throws SQLException {
        if (!this.isRequiresReorgTable(con, tableName)) {
            return;
        }
        CallableStatement callableStatement = null;
        try {
            callableStatement = con.prepareCall("call sysproc.admin_cmd(?)");
            callableStatement.setString(1, "reorg table " + tableName);
            callableStatement.execute();
        }
        finally {
            DataAccess.cleanUp((Statement)callableStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reorgTables(String[] templates) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        for (String template : templates) {
            if (!template.startsWith("alter table")) continue;
            tableNames.add(template.split(" ")[2]);
        }
        if (tableNames.isEmpty()) {
            return;
        }
        Connection con = null;
        try {
            con = DataAccess.getConnection();
            for (String tableName : tableNames) {
                this.reorgTable(con, tableName);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
    }

    @Override
    protected String reword(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] template;
                if (line.startsWith("alter_column_name ")) {
                    template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ add column @new-column@ @type@;\n", (String[])REWORD_TEMPLATE, (String[])template);
                    line = line + StringUtil.replace((String)"update @table@ set @new-column@ = @old-column@;\n", (String[])REWORD_TEMPLATE, (String[])template);
                    line = line + StringUtil.replace((String)"alter table @table@ drop column @old-column@", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_table_name ")) {
                    template = this.buildTableNameTokens(line);
                    line = StringUtil.replace((String)"alter table @old-table@ to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
                } else if (line.contains("drop index")) {
                    String[] tokens = StringUtil.split((String)line, (char)' ');
                    line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
                }
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

