/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.convert.FileSystemStoreRootDirException;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.store.AdvancedFileSystemStore;
import com.liferay.portlet.documentlibrary.store.CMISStore;
import com.liferay.portlet.documentlibrary.store.DBStore;
import com.liferay.portlet.documentlibrary.store.FileSystemStore;
import com.liferay.portlet.documentlibrary.store.JCRStore;
import com.liferay.portlet.documentlibrary.store.S3Store;
import com.liferay.portlet.documentlibrary.store.Store;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;

public class ConvertDocumentLibrary
extends ConvertProcess {
    private static final String _FILE_SYSTEM_STORE_SUFFIX = "FileSystemStore";
    private static final String[] _HOOKS = new String[]{AdvancedFileSystemStore.class.getName(), CMISStore.class.getName(), DBStore.class.getName(), FileSystemStore.class.getName(), JCRStore.class.getName(), S3Store.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(ConvertDocumentLibrary.class);
    private Store _sourceStore;
    private Store _targetStore;

    @Override
    public String getDescription() {
        return "migrate-documents-from-one-repository-to-another";
    }

    @Override
    public String getParameterDescription() {
        return "please-select-a-new-repository-hook";
    }

    @Override
    public String[] getParameterNames() {
        StringBundler sb = new StringBundler(_HOOKS.length * 2 + 2);
        sb.append("dl.store.impl");
        sb.append("=");
        for (String hook : _HOOKS) {
            if (hook.equals(PropsValues.DL_STORE_IMPL)) continue;
            sb.append(hook);
            sb.append(";");
        }
        return new String[]{sb.toString()};
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void validate() throws FileSystemStoreRootDirException {
        String sourceStoreClassName = this.getSourceStoreClassName();
        if (!sourceStoreClassName.endsWith(_FILE_SYSTEM_STORE_SUFFIX)) {
            return;
        }
        String targetStoreClassName = this.getTargetStoreClassName();
        if (!targetStoreClassName.endsWith(_FILE_SYSTEM_STORE_SUFFIX)) {
            return;
        }
        if (Validator.isBlank((String)PropsValues.DL_STORE_ADVANCED_FILE_SYSTEM_ROOT_DIR)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Property \"dl.store.advanced.file.system.root.dir is not set");
            }
            throw new FileSystemStoreRootDirException();
        }
        if (Validator.isBlank((String)PropsValues.DL_STORE_FILE_SYSTEM_ROOT_DIR)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Property \"dl.store.file.system.root.dir is not set");
            }
            throw new FileSystemStoreRootDirException();
        }
        if (PropsValues.DL_STORE_ADVANCED_FILE_SYSTEM_ROOT_DIR.equals(PropsValues.DL_STORE_FILE_SYSTEM_ROOT_DIR)) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(5);
                sb.append("Both properties \"");
                sb.append("dl.store.advanced.file.system.root.dir");
                sb.append("\" and \"");
                sb.append("dl.store.file.system.root.dir");
                sb.append("\" have the same value");
                _log.warn((Object)sb.toString());
            }
            throw new FileSystemStoreRootDirException();
        }
    }

    @Override
    protected void doConvert() throws Exception {
        this._sourceStore = StoreFactory.getInstance();
        String targetStoreClassName = this.getTargetStoreClassName();
        this._targetStore = (Store)InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)targetStoreClassName);
        this.migratePortlets();
        StoreFactory.setInstance(this._targetStore);
        MaintenanceUtil.appendStatus("Please set dl.store.impl in your portal-ext.properties to use " + targetStoreClassName);
        PropsValues.DL_STORE_IMPL = targetStoreClassName;
    }

    protected List<DLFileVersion> getDLFileVersions(DLFileEntry dlFileEntry) {
        List dlFileVersions = dlFileEntry.getFileVersions(-1);
        return ListUtil.sort((List)dlFileVersions, (Comparator)new FileVersionVersionComparator(true));
    }

    protected String getSourceStoreClassName() {
        Store sourceStore = StoreFactory.getInstance();
        return sourceStore.getClass().getName();
    }

    protected String getTargetStoreClassName() {
        String[] values = this.getParameterValues();
        return values[0];
    }

    protected void migrateDL() throws PortalException {
        int count = DLFileEntryLocalServiceUtil.getFileEntriesCount();
        MaintenanceUtil.appendStatus("Migrating " + count + " documents and media files");
        ActionableDynamicQuery actionableDynamicQuery = DLFileEntryLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                dynamicQuery.add(classNameIdProperty.eq((Object)0L));
            }
        });
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                ConvertDocumentLibrary.this.migrateDLFileEntry(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void migrateDLFileEntry(long companyId, long repositoryId, DLFileEntry dlFileEntry) {
        String fileName = dlFileEntry.getName();
        List<DLFileVersion> dlFileVersions = this.getDLFileVersions(dlFileEntry);
        if (dlFileVersions.isEmpty()) {
            String versionNumber = "1.0";
            this.migrateFile(companyId, repositoryId, fileName, versionNumber);
            return;
        }
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            String versionNumber = dlFileVersion.getVersion();
            this.migrateFile(companyId, repositoryId, fileName, versionNumber);
        }
    }

    protected void migrateFile(long companyId, long repositoryId, String fileName, String versionNumber) {
        try {
            InputStream is = this._sourceStore.getFileAsStream(companyId, repositoryId, fileName, versionNumber);
            if (versionNumber.equals("1.0")) {
                this._targetStore.addFile(companyId, repositoryId, fileName, is);
            } else {
                this._targetStore.updateFile(companyId, repositoryId, fileName, versionNumber, is);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Migration failed for " + fileName), (Throwable)e);
        }
    }

    protected void migrateImages() throws PortalException {
        int count = ImageLocalServiceUtil.getImagesCount();
        MaintenanceUtil.appendStatus("Migrating " + count + " images");
        ActionableDynamicQuery actionableDynamicQuery = ImageLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) {
                Image image = (Image)object;
                String fileName = image.getImageId() + "." + image.getType();
                ConvertDocumentLibrary.this.migrateFile(0L, 0L, fileName, "1.0");
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void migrateMB() throws PortalException {
        int count = MBMessageLocalServiceUtil.getMBMessagesCount();
        MaintenanceUtil.appendStatus("Migrating message boards attachments in " + count + " messages");
        ActionableDynamicQuery actionableDynamicQuery = MBMessageLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                MBMessage mbMessage = (MBMessage)object;
                for (FileEntry fileEntry : mbMessage.getAttachmentsFileEntries()) {
                    DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
                    ConvertDocumentLibrary.this.migrateDLFileEntry(mbMessage.getCompanyId(), DLFolderConstants.getDataRepositoryId((long)dlFileEntry.getRepositoryId(), (long)dlFileEntry.getFolderId()), dlFileEntry);
                }
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void migratePortlets() throws Exception {
        this.migrateImages();
        this.migrateDL();
        this.migrateMB();
        this.migrateWiki();
    }

    protected void migrateWiki() throws PortalException {
        int count = WikiPageLocalServiceUtil.getWikiPagesCount();
        MaintenanceUtil.appendStatus("Migrating wiki page attachments in " + count + " pages");
        ActionableDynamicQuery actionableDynamicQuery = WikiPageLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"head");
                dynamicQuery.add(property.eq((Object)true));
            }
        });
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) {
                WikiPage wikiPage = (WikiPage)object;
                for (FileEntry fileEntry : wikiPage.getAttachmentsFileEntries()) {
                    DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
                    ConvertDocumentLibrary.this.migrateDLFileEntry(wikiPage.getCompanyId(), DLFolderConstants.getDataRepositoryId((long)dlFileEntry.getRepositoryId(), (long)dlFileEntry.getFolderId()), dlFileEntry);
                }
            }
        });
        actionableDynamicQuery.performActions();
    }
}

