/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.mail.model.CyrusUser;
import com.liferay.mail.model.CyrusVirtual;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.ServiceComponent;
import com.liferay.portal.service.ServiceComponentLocalServiceUtil;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.upgrade.util.Table;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.ShutdownUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;

public class ConvertDatabase
extends ConvertProcess {
    private static final Tuple[] _UNMAPPED_TABLES = new Tuple[]{new Tuple(new Object[]{"CyrusUser", CyrusUser.TABLE_COLUMNS, "create table CyrusUser (userId VARCHAR(75) not null primary key, password_ VARCHAR(75) not null)"}), new Tuple(new Object[]{"CyrusVirtual", CyrusVirtual.TABLE_COLUMNS, "create table CyrusVirtual (emailAddress VARCHAR(75) not null primary key, userId VARCHAR(75) not null)"})};
    private static Log _log = LogFactoryUtil.getLog(ConvertDatabase.class);

    @Override
    public String getDescription() {
        return "migrate-data-from-one-database-to-another";
    }

    @Override
    public String getParameterDescription() {
        return "please-enter-jdbc-information-for-new-database";
    }

    @Override
    public String[] getParameterNames() {
        return new String[]{"jdbc-driver-class-name", "jdbc-url", "jdbc-user-name", "jdbc-password"};
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConvert() throws Exception {
        DataSource dataSource = this.getDataSource();
        Dialect dialect = DialectDetector.getDialect(dataSource);
        DB db = DBFactoryUtil.getDB((Object)dialect);
        List modelNames = ModelHintsUtil.getModels();
        LinkedHashMap<String, Tuple> tableDetails = new LinkedHashMap<String, Tuple>();
        Connection connection = dataSource.getConnection();
        try {
            MaintenanceUtil.appendStatus("Collecting information for database tables to migration");
            for (String modelName : modelNames) {
                Field[] fields;
                Class<?> implClass;
                if (!modelName.contains(".model.")) continue;
                String implClassName = modelName.replaceFirst("(\\.model\\.)(\\p{Upper}.*)", "$1impl.$2Impl");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Loading class " + implClassName));
                }
                if ((implClass = this.getImplClass(implClassName)) == null) {
                    _log.error((Object)("Unable to load class " + implClassName));
                    continue;
                }
                for (Field field : fields = implClass.getFields()) {
                    Tuple tuple = null;
                    String fieldName = field.getName();
                    if (fieldName.equals("TABLE_NAME") || fieldName.startsWith("MAPPING_TABLE_") && fieldName.endsWith("_NAME")) {
                        tuple = this.getTableDetails(implClass, field, fieldName);
                    }
                    if (tuple == null) continue;
                    String table = (String)tuple.getObject(0);
                    tableDetails.put(table, tuple);
                }
            }
            for (Tuple tuple : _UNMAPPED_TABLES) {
                String table = (String)tuple.getObject(0);
                tableDetails.put(table, tuple);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Migrating database tables");
            }
            int i = 0;
            for (Tuple tuple : tableDetails.values()) {
                if (i > 0 && i % (tableDetails.size() / 4) == 0) {
                    MaintenanceUtil.appendStatus(i * 100 / tableDetails.size() + "%");
                }
                String table = (String)tuple.getObject(0);
                Object[][] columns = (Object[][])tuple.getObject(1);
                String sqlCreate = (String)tuple.getObject(2);
                this.migrateTable(db, connection, table, columns, sqlCreate);
                ++i;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Migrating database indexes");
            }
            StartupHelperUtil.updateIndexes(db, connection, false);
            List serviceComponents = ServiceComponentLocalServiceUtil.getServiceComponents((int)-1, (int)-1);
            HashSet validIndexNames = new HashSet();
            for (ServiceComponent serviceComponent : serviceComponents) {
                String indexesSQL = serviceComponent.getIndexesSQL();
                db.addIndexes(connection, indexesSQL, validIndexNames);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)connection);
        }
        MaintenanceUtil.appendStatus("Please change your JDBC settings before restarting server");
        ShutdownUtil.shutdown(0L);
    }

    protected DataSource getDataSource() throws Exception {
        String[] values = this.getParameterValues();
        String driverClassName = values[0];
        String url = values[1];
        String userName = values[2];
        String password = values[3];
        String jndiName = "";
        return DataSourceFactoryUtil.initDataSource((String)driverClassName, (String)url, (String)userName, (String)password, (String)jndiName);
    }

    protected Class<?> getImplClass(String implClassName) throws Exception {
        try {
            ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
            return classLoader.loadClass(implClassName);
        }
        catch (Exception e) {
            for (String servletContextName : ServletContextPool.keySet()) {
                try {
                    ServletContext servletContext = ServletContextPool.get((String)servletContextName);
                    ClassLoader classLoader = (ClassLoader)servletContext.getAttribute("PLUGIN_CLASS_LOADER");
                    return classLoader.loadClass(implClassName);
                }
                catch (Exception e2) {
                }
            }
            return null;
        }
    }

    protected Tuple getTableDetails(Class<?> implClass, Field tableField, String tableFieldVar) {
        try {
            String columnsFieldVar = StringUtil.replace((String)tableFieldVar, (String)"_NAME", (String)"_COLUMNS");
            String sqlCreateFieldVar = StringUtil.replace((String)tableFieldVar, (String)"_NAME", (String)"_SQL_CREATE");
            Field columnsField = implClass.getField(columnsFieldVar);
            Field sqlCreateField = implClass.getField(sqlCreateFieldVar);
            String table = (String)tableField.get("");
            Object[][] columns = (Object[][])columnsField.get(new Object[0][0]);
            String sqlCreate = (String)sqlCreateField.get("");
            return new Tuple(new Object[]{table, columns, sqlCreate});
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void migrateTable(DB db, Connection connection, String tableName, Object[][] columns, String sqlCreate) throws Exception {
        Table table = new Table(tableName, columns);
        try {
            table.generateTempFile();
            db.runSQL(connection, sqlCreate);
            table.populateTable(connection);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            MaintenanceUtil.appendStatus(e.getMessage());
        }
    }
}

