/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.comment;

import com.liferay.portal.comment.DummyCommentManagerImpl;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.service.ServiceContext;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;

public class CommentManagerImpl
implements CommentManager {
    private CommentManager _defaultCommentManager = new DummyCommentManagerImpl();
    private ServiceTracker<CommentManager, CommentManager> _serviceTracker;

    public CommentManagerImpl() {
        Registry registry = RegistryUtil.getRegistry();
        Class<?> clazz = this.getClass();
        Filter filter = registry.getFilter("(&(objectClass=" + CommentManager.class.getName() + ")(!(objectClass=" + clazz.getName() + ")))");
        this._serviceTracker = registry.trackServices(filter);
        this._serviceTracker.open();
    }

    public void addComment(long userId, long groupId, String className, long classPK, String body, ServiceContext serviceContext) throws PortalException {
        CommentManager commentManager = this.getCommentManager();
        commentManager.addComment(userId, groupId, className, classPK, body, serviceContext);
    }

    public long addComment(long userId, long groupId, String className, long classPK, String userName, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        CommentManager commentManager = this.getCommentManager();
        return commentManager.addComment(userId, groupId, className, classPK, userName, subject, body, serviceContextFunction);
    }

    public void addDiscussion(long userId, long groupId, String className, long classPK, String userName) throws PortalException {
        CommentManager commentManager = this.getCommentManager();
        commentManager.addDiscussion(userId, groupId, className, classPK, userName);
    }

    public void deleteComment(long commentId) throws PortalException {
        CommentManager commentManager = this.getCommentManager();
        commentManager.deleteComment(commentId);
    }

    public void deleteDiscussion(String className, long classPK) throws PortalException {
        CommentManager commentManager = this.getCommentManager();
        commentManager.deleteDiscussion(className, classPK);
    }

    public int getCommentsCount(String className, long classPK) {
        CommentManager commentManager = this.getCommentManager();
        return commentManager.getCommentsCount(className, classPK);
    }

    protected CommentManager getCommentManager() {
        if (this._serviceTracker.isEmpty()) {
            return this._defaultCommentManager;
        }
        return (CommentManager)this._serviceTracker.getService();
    }

    protected void setDefaultCommentManager(CommentManager defaultCommentManager) {
        this._defaultCommentManager = defaultCommentManager;
    }
}

