/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.bean.IdentifiableBeanInvokerUtil;
import com.liferay.portal.cluster.ClusterableContextThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterInvokeAcceptor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;

public class ClusterableInvokerUtil {
    private static MethodKey _invokeMethodKey = new MethodKey(ClusterableInvokerUtil.class, "_invoke", new Class[]{MethodHandler.class, Class.class, Map.class});

    public static MethodHandler createMethodHandler(Class<? extends ClusterInvokeAcceptor> clusterInvokeAcceptorClass, MethodInvocation methodInvocation) {
        MethodHandler methodHandler = IdentifiableBeanInvokerUtil.createMethodHandler(methodInvocation);
        Map<String, Serializable> context = ClusterableContextThreadLocal.collectThreadLocalContext();
        ClusterableInvokerUtil._populateContextFromThreadLocals(context);
        if (clusterInvokeAcceptorClass == ClusterInvokeAcceptor.class) {
            clusterInvokeAcceptorClass = null;
        }
        return new MethodHandler(_invokeMethodKey, new Object[]{methodHandler, clusterInvokeAcceptorClass, context});
    }

    private static Object _invoke(MethodHandler methodHandler, Class<? extends ClusterInvokeAcceptor> clusterInvokeAcceptorClass, Map<String, Serializable> context) throws Exception {
        if (clusterInvokeAcceptorClass != null) {
            ClusterInvokeAcceptor clusterInvokeAcceptor;
            Constructor<? extends ClusterInvokeAcceptor> constructor = clusterInvokeAcceptorClass.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            if (!(clusterInvokeAcceptor = constructor.newInstance(new Object[0])).accept(context)) {
                return null;
            }
        }
        ClusterableInvokerUtil._populateThreadLocalsFromContext(context);
        return methodHandler.invoke();
    }

    private static void _populateContextFromThreadLocals(Map<String, Serializable> context) {
        if (!context.containsKey("companyId")) {
            context.put("companyId", CompanyThreadLocal.getCompanyId());
        }
        if (!context.containsKey("defaultLocale")) {
            context.put("defaultLocale", LocaleThreadLocal.getDefaultLocale());
        }
        if (!context.containsKey("groupId")) {
            context.put("groupId", GroupThreadLocal.getGroupId());
        }
        if (!context.containsKey("principalName")) {
            context.put("principalName", (Serializable)((Object)PrincipalThreadLocal.getName()));
        }
        if (!context.containsKey("principalPassword")) {
            context.put("principalPassword", (Serializable)((Object)PrincipalThreadLocal.getPassword()));
        }
        if (!context.containsKey("siteDefaultLocale")) {
            context.put("siteDefaultLocale", LocaleThreadLocal.getSiteDefaultLocale());
        }
        if (!context.containsKey("themeDisplayLocale")) {
            context.put("themeDisplayLocale", LocaleThreadLocal.getThemeDisplayLocale());
        }
    }

    private static void _populateThreadLocalsFromContext(Map<String, Serializable> context) {
        Locale themeDisplayLocale;
        Locale siteDefaultLocale;
        String principalPassword;
        String principalName;
        long groupId;
        Locale defaultLocale;
        long companyId = GetterUtil.getLong((Object)context.get("companyId"));
        if (companyId > 0L) {
            CompanyThreadLocal.setCompanyId((Long)companyId);
        }
        if ((defaultLocale = (Locale)context.get("defaultLocale")) != null) {
            LocaleThreadLocal.setDefaultLocale((Locale)defaultLocale);
        }
        if ((groupId = GetterUtil.getLong((Object)context.get("groupId"))) > 0L) {
            GroupThreadLocal.setGroupId((Long)groupId);
        }
        if (Validator.isNotNull((String)(principalName = GetterUtil.getString((Object)context.get("principalName"))))) {
            PrincipalThreadLocal.setName((String)principalName);
        }
        PermissionChecker permissionChecker = null;
        if (Validator.isNotNull((String)principalName)) {
            try {
                User user = UserLocalServiceUtil.fetchUser((long)PrincipalThreadLocal.getUserId());
                permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (permissionChecker != null) {
            PermissionThreadLocal.setPermissionChecker(permissionChecker);
        }
        if (Validator.isNotNull((String)(principalPassword = GetterUtil.getString((Object)context.get("principalPassword"))))) {
            PrincipalThreadLocal.setPassword((String)principalPassword);
        }
        if ((siteDefaultLocale = (Locale)context.get("siteDefaultLocale")) != null) {
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
        if ((themeDisplayLocale = (Locale)context.get("themeDisplayLocale")) != null) {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)themeDisplayLocale);
        }
    }
}

