/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.AddressSerializerUtil;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterTokenTransitionListener;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.concurrent.NoticeableFutureConverter;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;
import java.util.HashSet;
import java.util.Set;

public class ClusterMasterExecutorImpl
implements ClusterMasterExecutor {
    private static final String _LOCK_CLASS_NAME = ClusterMasterExecutorImpl.class.getName();
    private static Log _log = LogFactoryUtil.getLog(ClusterMasterExecutorImpl.class);
    private static volatile boolean _master;
    private ClusterEventListener _clusterEventListener;
    private ClusterExecutor _clusterExecutor;
    private Set<ClusterMasterTokenTransitionListener> _clusterMasterTokenTransitionListeners = new HashSet<ClusterMasterTokenTransitionListener>();
    private volatile boolean _enabled;
    private volatile String _localClusterNodeAddress;

    public void destroy() {
        block3: {
            if (!this._enabled) {
                return;
            }
            try {
                this._clusterExecutor.removeClusterEventListener(this._clusterEventListener);
                LockLocalServiceUtil.unlock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress);
            }
            catch (SystemException se) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to destroy the cluster master executor", (Throwable)se);
            }
        }
    }

    public <T> NoticeableFuture<T> executeOnMaster(MethodHandler methodHandler) {
        if (!this._enabled) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Executing on the local node because the cluster master executor is disabled");
            }
            DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
            try {
                defaultNoticeableFuture.set(methodHandler.invoke());
                return defaultNoticeableFuture;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        String masterAddressString = this.getMasterAddressString();
        final Address address = AddressSerializerUtil.deserialize((String)masterAddressString);
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)methodHandler, (Address[])new Address[]{address});
        try {
            return new NoticeableFutureConverter<T, ClusterNodeResponses>((NoticeableFuture)this._clusterExecutor.execute(clusterRequest)){

                protected T convert(ClusterNodeResponses clusterNodeResponses) {
                    return clusterNodeResponses.getClusterResponse(address);
                }
            };
        }
        catch (Exception e) {
            throw new SystemException("Unable to execute on master " + address.getDescription(), (Throwable)e);
        }
    }

    public void initialize() {
        if (!this._clusterExecutor.isEnabled()) {
            return;
        }
        try {
            this._localClusterNodeAddress = AddressSerializerUtil.serialize((Address)this._clusterExecutor.getLocalClusterNodeAddress());
            this._clusterEventListener = new ClusterMasterTokenClusterEventListener();
            this._clusterExecutor.addClusterEventListener(this._clusterEventListener);
            String masterAddressString = this.getMasterAddressString();
            this._enabled = true;
            this.notifyMasterTokenTransitionListeners(this._localClusterNodeAddress.equals(masterAddressString));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize cluster master executor", e);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isMaster() {
        return _master;
    }

    public void registerClusterMasterTokenTransitionListener(ClusterMasterTokenTransitionListener clusterMasterTokenTransitionListener) {
        this._clusterMasterTokenTransitionListeners.add(clusterMasterTokenTransitionListener);
    }

    public void setClusterExecutor(ClusterExecutor clusterExecutor) {
        this._clusterExecutor = clusterExecutor;
    }

    public void setClusterMasterTokenTransitionListeners(Set<ClusterMasterTokenTransitionListener> clusterMasterTokenTransitionListeners) {
        this._clusterMasterTokenTransitionListeners.addAll(clusterMasterTokenTransitionListeners);
    }

    public void unregisterClusterMasterTokenTransitionListener(ClusterMasterTokenTransitionListener clusterMasterTokenTransitionListener) {
        this._clusterMasterTokenTransitionListeners.remove(clusterMasterTokenTransitionListener);
    }

    protected String getMasterAddressString() {
        String owner = null;
        while (true) {
            block7: {
                try {
                    Lock lock = null;
                    lock = owner == null ? LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress) : LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, owner, (String)this._localClusterNodeAddress);
                    owner = lock.getOwner();
                    Address address = AddressSerializerUtil.deserialize((String)owner);
                    if (this._clusterExecutor.isClusterNodeAlive(address)) {
                        break;
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)"Unable to acquire memory scheduler cluster lock", (Throwable)e);
                }
            }
            if (!_log.isInfoEnabled()) continue;
            if (Validator.isNotNull(owner)) {
                _log.info((Object)("Lock currently held by " + owner));
            }
            _log.info((Object)"Reattempting to acquire memory scheduler cluster lock");
        }
        boolean master = this._localClusterNodeAddress.equals(owner);
        if (master == _master) {
            return owner;
        }
        _master = master;
        if (this._enabled) {
            this.notifyMasterTokenTransitionListeners(master);
        }
        return owner;
    }

    protected void notifyMasterTokenTransitionListeners(boolean masterTokenAcquired) {
        for (ClusterMasterTokenTransitionListener clusterMasterTokenTransitionListener : this._clusterMasterTokenTransitionListeners) {
            if (masterTokenAcquired) {
                clusterMasterTokenTransitionListener.masterTokenAcquired();
                continue;
            }
            clusterMasterTokenTransitionListener.masterTokenReleased();
        }
    }

    private class ClusterMasterTokenClusterEventListener
    implements ClusterEventListener {
        private ClusterMasterTokenClusterEventListener() {
        }

        public void processClusterEvent(ClusterEvent clusterEvent) {
            try {
                ClusterMasterExecutorImpl.this.getMasterAddressString();
            }
            catch (Exception e) {
                _log.error((Object)"Unable to update the cluster master lock", (Throwable)e);
            }
        }
    }
}

