/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.BaseReceiver;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SocketUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

public abstract class ClusterBase {
    private static Log _log = LogFactoryUtil.getLog(ClusterBase.class);
    private static boolean _initialized;

    public void afterPropertiesSet() {
        if (!this.isEnabled()) {
            return;
        }
        if (!_initialized) {
            block7: {
                this.initSystemProperties();
                try {
                    this.initBindAddress();
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)"Failed to initialize outgoing IP address", (Throwable)e);
                }
            }
            _initialized = true;
        }
        try {
            this.initChannels();
        }
        catch (Exception e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"Unable to initialize channels", (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
    }

    public abstract void destroy();

    public boolean isEnabled() {
        return PropsValues.CLUSTER_LINK_ENABLED;
    }

    protected JChannel createJChannel(String properties, Receiver receiver, String clusterName) throws Exception {
        JChannel jChannel = new JChannel(properties);
        jChannel.setReceiver(receiver);
        jChannel.connect(clusterName);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Create a new channel with properties " + jChannel.getProperties()));
        }
        return jChannel;
    }

    protected List<Address> getAddresses(JChannel channel) {
        BaseReceiver baseReceiver = (BaseReceiver)channel.getReceiver();
        View view = baseReceiver.getView();
        List jGroupsAddresses = view.getMembers();
        if (jGroupsAddresses == null) {
            return Collections.emptyList();
        }
        ArrayList<Address> addresses = new ArrayList<Address>(jGroupsAddresses.size());
        for (org.jgroups.Address jgroupsAddress : jGroupsAddresses) {
            addresses.add(new AddressImpl(jgroupsAddress));
        }
        return addresses;
    }

    protected InetAddress getBindInetAddress(JChannel jChannel) {
        ProtocolStack protocolStack = jChannel.getProtocolStack();
        Protocol protocol = protocolStack.getBottomProtocol();
        return (InetAddress)protocol.getValue("bind_addr");
    }

    protected void initBindAddress() throws Exception {
        String autodetectAddress = PropsValues.CLUSTER_LINK_AUTODETECT_ADDRESS;
        if (Validator.isNull((String)autodetectAddress)) {
            return;
        }
        String host = autodetectAddress;
        int port = 80;
        int index = autodetectAddress.indexOf(58);
        if (index != -1) {
            host = autodetectAddress.substring(0, index);
            port = GetterUtil.getInteger((String)autodetectAddress.substring(index + 1), (int)port);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Autodetecting JGroups outgoing IP address and interface for " + host + ":" + port));
        }
        SocketUtil.BindInfo bindInfo = SocketUtil.getBindInfo((String)host, (int)port);
        InetAddress inetAddress = bindInfo.getInetAddress();
        NetworkInterface networkInterface = bindInfo.getNetworkInterface();
        System.setProperty("jgroups.bind_addr", inetAddress.getHostAddress());
        System.setProperty("jgroups.bind_interface", networkInterface.getName());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Setting JGroups outgoing IP address to " + inetAddress.getHostAddress() + " and interface to " + networkInterface.getName()));
        }
    }

    protected abstract void initChannels() throws Exception;

    protected void initSystemProperties() {
        for (String systemProperty : PropsValues.CLUSTER_LINK_CHANNEL_SYSTEM_PROPERTIES) {
            int index = systemProperty.indexOf(58);
            if (index == -1) continue;
            String key = systemProperty.substring(0, index);
            String value = systemProperty.substring(index + 1);
            System.setProperty(key, value);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Setting system property {key=" + key + ", value=" + value + "}"));
        }
    }
}

