/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.transactional;

import com.liferay.portal.cache.transactional.TransactionalPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionalPortalCacheHelper {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new TransactionLifecycleListener(){

        public void created(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            TransactionalPortalCacheHelper.begin();
        }

        public void committed(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            TransactionalPortalCacheHelper.commit();
        }

        public void rollbacked(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
            TransactionalPortalCacheHelper.rollback();
            EntityCacheUtil.clearLocalCache();
            FinderCacheUtil.clearLocalCache();
        }
    };
    private static ValueEntry _NULL_HOLDER_VALUE_ENTRY = new ValueEntry(TransactionalPortalCache.NULL_HOLDER, 0, false);
    private static ThreadLocal<List<PortalCacheMap>> _portalCacheMapsThreadLocal = new InitialThreadLocal(TransactionalPortalCacheHelper.class.getName() + "._portalCacheMapsThreadLocal", new ArrayList());

    public static void begin() {
        if (!PropsValues.TRANSACTIONAL_CACHE_ENABLED) {
            return;
        }
        TransactionalPortalCacheHelper._pushPortalCacheMap();
    }

    public static void commit() {
        if (!PropsValues.TRANSACTIONAL_CACHE_ENABLED) {
            return;
        }
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._popPortalCacheMap();
        for (Map.Entry portalCacheMapEntry : portalCacheMap.entrySet()) {
            PortalCache portalCache = (PortalCache)portalCacheMapEntry.getKey();
            UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMapEntry.getValue();
            uncommittedBuffer.commitTo((PortalCache<Serializable, Object>)portalCache);
        }
        portalCacheMap.clear();
    }

    public static boolean isEnabled() {
        if (!PropsValues.TRANSACTIONAL_CACHE_ENABLED) {
            return false;
        }
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        return !portalCacheMaps.isEmpty();
    }

    public static void rollback() {
        if (!PropsValues.TRANSACTIONAL_CACHE_ENABLED) {
            return;
        }
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._popPortalCacheMap();
        portalCacheMap.clear();
    }

    protected static <K extends Serializable, V> V get(PortalCache<K, V> portalCache, K key) {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._peekPortalCacheMap();
        UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMap.get(portalCache);
        if (uncommittedBuffer == null) {
            return null;
        }
        ValueEntry valueEntry = uncommittedBuffer.get(key);
        if (valueEntry == null) {
            return null;
        }
        return (V)valueEntry._value;
    }

    protected static <K extends Serializable, V> void put(PortalCache<K, V> portalCache, K key, V value, boolean quiet, int ttl) {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._peekPortalCacheMap();
        UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMap.get(portalCache);
        if (uncommittedBuffer == null) {
            uncommittedBuffer = new UncommittedBuffer();
            portalCacheMap.put(portalCache, uncommittedBuffer);
        }
        uncommittedBuffer.put(key, new ValueEntry(value, ttl, quiet));
    }

    protected static <K extends Serializable, V> void removeAll(PortalCache<K, V> portalCache) {
        PortalCacheMap portalCacheMap = TransactionalPortalCacheHelper._peekPortalCacheMap();
        UncommittedBuffer uncommittedBuffer = (UncommittedBuffer)portalCacheMap.get(portalCache);
        if (uncommittedBuffer == null) {
            uncommittedBuffer = new UncommittedBuffer();
            portalCacheMap.put(portalCache, uncommittedBuffer);
        }
        uncommittedBuffer.removeAll();
    }

    private static PortalCacheMap _peekPortalCacheMap() {
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        return portalCacheMaps.get(portalCacheMaps.size() - 1);
    }

    private static PortalCacheMap _popPortalCacheMap() {
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        return portalCacheMaps.remove(portalCacheMaps.size() - 1);
    }

    private static void _pushPortalCacheMap() {
        List<PortalCacheMap> portalCacheMaps = _portalCacheMapsThreadLocal.get();
        portalCacheMaps.add(new PortalCacheMap());
    }

    private static class ValueEntry {
        private boolean _quiet;
        private int _ttl;
        private Object _value;

        public ValueEntry(Object value, int ttl, boolean quiet) {
            this._value = value;
            this._ttl = ttl;
            this._quiet = quiet;
        }

        public void commitTo(PortalCache<Serializable, Object> portalCache, Serializable key) {
            if (this._value == TransactionalPortalCache.NULL_HOLDER) {
                portalCache.remove(key);
            } else if (this._quiet) {
                portalCache.putQuiet(key, this._value, this._ttl);
            } else {
                portalCache.put(key, this._value, this._ttl);
            }
        }

        public void merge(ValueEntry valueEntry) {
            if (!this._quiet) {
                valueEntry._quiet = false;
            }
        }
    }

    private static class UncommittedBuffer {
        private boolean _removeAll;
        private Map<Serializable, ValueEntry> _uncommittedMap = new HashMap<Serializable, ValueEntry>();

        private UncommittedBuffer() {
        }

        public void commitTo(PortalCache<Serializable, Object> portalCache) {
            if (this._removeAll) {
                portalCache.removeAll();
            }
            for (Map.Entry<Serializable, ValueEntry> entry : this._uncommittedMap.entrySet()) {
                ValueEntry valueEntry = entry.getValue();
                valueEntry.commitTo(portalCache, entry.getKey());
            }
        }

        public ValueEntry get(Serializable key) {
            ValueEntry valueEntry = this._uncommittedMap.get(key);
            if (valueEntry == null && this._removeAll) {
                valueEntry = _NULL_HOLDER_VALUE_ENTRY;
            }
            return valueEntry;
        }

        public void put(Serializable key, ValueEntry valueEntry) {
            ValueEntry oldValueEntry = this._uncommittedMap.put(key, valueEntry);
            if (oldValueEntry != null) {
                oldValueEntry.merge(valueEntry);
            }
        }

        public void removeAll() {
            this._uncommittedMap.clear();
            this._removeAll = true;
        }
    }

    private static class PortalCacheMap
    extends HashMap<PortalCache<? extends Serializable, ?>, UncommittedBuffer> {
        private PortalCacheMap() {
        }
    }
}

