/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.transactional;

import com.liferay.portal.cache.transactional.TransactionalPortalCacheHelper;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheWrapper;
import java.io.Serializable;

public class TransactionalPortalCache<K extends Serializable, V>
extends PortalCacheWrapper<K, V> {
    protected static Serializable NULL_HOLDER = "NULL_HOLDER";

    public TransactionalPortalCache(PortalCache<K, V> portalCache) {
        super(portalCache);
    }

    public V get(K key) {
        Object result = null;
        if (TransactionalPortalCacheHelper.isEnabled()) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            result = TransactionalPortalCacheHelper.get(this.portalCache, key);
            if (result == NULL_HOLDER) {
                return null;
            }
        }
        if (result == null) {
            result = this.portalCache.get(key);
        }
        return (V)result;
    }

    public void put(K key, V value) {
        this.doPut(key, value, 0, false);
    }

    public void put(K key, V value, int timeToLive) {
        this.doPut(key, value, timeToLive, false);
    }

    public void putQuiet(K key, V value) {
        this.doPut(key, value, 0, true);
    }

    public void putQuiet(K key, V value, int timeToLive) {
        this.doPut(key, value, timeToLive, true);
    }

    public void remove(K key) {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            TransactionalPortalCacheHelper.put(this.portalCache, key, NULL_HOLDER, false, 0);
        } else {
            this.portalCache.remove(key);
        }
    }

    public void removeAll() {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            TransactionalPortalCacheHelper.removeAll(this.portalCache);
        } else {
            this.portalCache.removeAll();
        }
    }

    protected void doPut(K key, V value, int timeToLive, boolean quiet) {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (timeToLive < 0) {
                throw new IllegalArgumentException("Time to live is negative");
            }
            TransactionalPortalCacheHelper.put(this.portalCache, key, value, quiet, timeToLive);
        } else if (quiet) {
            this.portalCache.putQuiet(key, value, timeToLive);
        } else {
            this.portalCache.put(key, value, timeToLive);
        }
    }
}

