/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.mvcc;

import com.liferay.portal.cache.ehcache.LockBasedMVCCEhcachePortalCache;
import com.liferay.portal.cache.mvcc.MVCCPortalCache;
import com.liferay.portal.kernel.cache.LowLevelCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheWrapper;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;

public class MVCCPortalCacheFactory {
    public static <K extends Serializable> PortalCache<K, ?> createMVCCEhcachePortalCache(PortalCache<K, ?> portalCache) {
        if (portalCache instanceof LowLevelCache) {
            if (PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED) {
                return new MVCCPortalCache((LowLevelCache)portalCache);
            }
            return new LockBasedMVCCEhcachePortalCache((LowLevelCache)portalCache);
        }
        PortalCache currentPortalCache = portalCache;
        while (currentPortalCache instanceof PortalCacheWrapper) {
            PortalCacheWrapper portalCacheWrapper = (PortalCacheWrapper)currentPortalCache;
            Object nextPortalCache = portalCacheWrapper.getWrappedPortalCache();
            if (nextPortalCache instanceof LowLevelCache) {
                nextPortalCache = PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED ? new MVCCPortalCache((LowLevelCache)nextPortalCache) : new LockBasedMVCCEhcachePortalCache((LowLevelCache)nextPortalCache);
                portalCacheWrapper.setPortalCache(nextPortalCache);
                break;
            }
            currentPortalCache = nextPortalCache;
        }
        return portalCache;
    }
}

