/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.mvcc;

import com.liferay.portal.kernel.cache.AggregatedCacheListener;
import com.liferay.portal.kernel.cache.LowLevelCache;
import com.liferay.portal.kernel.cache.PortalCacheWrapper;
import com.liferay.portal.model.MVCCModel;
import java.io.Serializable;

public class MVCCPortalCache<K extends Serializable, V extends MVCCModel>
extends PortalCacheWrapper<K, V> {
    private LowLevelCache<K, V> _lowLevelCache;

    public MVCCPortalCache(LowLevelCache<K, V> lowLevelCache) {
        super(lowLevelCache);
        this._lowLevelCache = lowLevelCache;
    }

    public void put(K key, V value) {
        this.doPut(key, value, 0, false);
    }

    public void put(K key, V value, int timeToLive) {
        this.doPut(key, value, timeToLive, false);
    }

    public void putQuiet(K key, V value) {
        this.doPut(key, value, 0, true);
    }

    public void putQuiet(K key, V value, int timeToLive) {
        this.doPut(key, value, timeToLive, true);
    }

    protected void doPut(K key, V value, int timeToLive, boolean quiet) {
        boolean skipListener = false;
        if (quiet) {
            skipListener = AggregatedCacheListener.isSkipListener();
            AggregatedCacheListener.setSkipListener((boolean)true);
        }
        try {
            while (true) {
                MVCCModel oldValue;
                if ((oldValue = (MVCCModel)this._lowLevelCache.get(key)) == null && (oldValue = (MVCCModel)this._lowLevelCache.putIfAbsent(key, value, timeToLive)) == null) {
                    return;
                }
                if (value.getMvccVersion() <= oldValue.getMvccVersion()) {
                    return;
                }
                if (!this._lowLevelCache.replace(key, (Object)oldValue, value, timeToLive)) continue;
                return;
            }
        }
        finally {
            if (quiet) {
                AggregatedCacheListener.setSkipListener((boolean)skipListener);
            }
        }
    }
}

