/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memory;

import com.liferay.portal.cache.AbstractPortalCacheManager;
import com.liferay.portal.cache.cluster.ClusterLinkCallbackFactory;
import com.liferay.portal.cache.memory.MemoryPortalCache;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.configuration.CallbackConfiguration;
import com.liferay.portal.kernel.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.kernel.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MemoryPortalCacheManager<K extends Serializable, V>
extends AbstractPortalCacheManager<K, V> {
    private int _cacheInitialCapacity = 10000;
    private int _cacheManagerInitialCapacity = 10000;
    private ConcurrentMap<String, MemoryPortalCache<K, V>> _memoryPortalCaches;
    private String _name;

    public String getName() {
        return this._name;
    }

    public void reconfigureCaches(URL configurationURL) {
        throw new UnsupportedOperationException();
    }

    public void setCacheInitialCapacity(int cacheInitialCapacity) {
        this._cacheInitialCapacity = cacheInitialCapacity;
    }

    public void setCacheManagerInitialCapacity(int cacheManagerInitialCapacity) {
        this._cacheManagerInitialCapacity = cacheManagerInitialCapacity;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    protected PortalCache<K, V> createPortalCache(String cacheName) {
        MemoryPortalCache portalCache = (MemoryPortalCache)((Object)this._memoryPortalCaches.get(cacheName));
        if (portalCache != null) {
            return portalCache;
        }
        portalCache = new MemoryPortalCache(this, cacheName, this._cacheInitialCapacity);
        MemoryPortalCache previousPortalCache = this._memoryPortalCaches.putIfAbsent(cacheName, portalCache);
        if (previousPortalCache == null) {
            this.aggregatedCacheManagerListener.notifyCacheAdded(cacheName);
        } else {
            portalCache = previousPortalCache;
        }
        return portalCache;
    }

    @Override
    protected void doClearAll() {
        for (MemoryPortalCache memoryPortalCache : this._memoryPortalCaches.values()) {
            memoryPortalCache.removeAll();
        }
    }

    @Override
    protected void doDestroy() {
        for (MemoryPortalCache memoryPortalCache : this._memoryPortalCaches.values()) {
            memoryPortalCache.destroy();
        }
        this.aggregatedCacheManagerListener.dispose();
    }

    @Override
    protected void doRemoveCache(String cacheName) {
        MemoryPortalCache memoryPortalCache = (MemoryPortalCache)((Object)this._memoryPortalCaches.remove(cacheName));
        memoryPortalCache.destroy();
        this.aggregatedCacheManagerListener.notifyCacheRemoved(cacheName);
    }

    @Override
    protected PortalCacheManagerConfiguration getPortalCacheManagerConfiguration() {
        PortalCacheConfiguration defaultPortalCacheConfiguration = null;
        if (this.clusterAware && PropsValues.CLUSTER_LINK_ENABLED) {
            CallbackConfiguration cacheListenerConfiguration = new CallbackConfiguration(ClusterLinkCallbackFactory.INSTANCE, new Properties());
            HashMap<CallbackConfiguration, CacheListenerScope> cacheListenerConfigurations = new HashMap<CallbackConfiguration, CacheListenerScope>();
            cacheListenerConfigurations.put(cacheListenerConfiguration, CacheListenerScope.ALL);
            CallbackConfiguration bootstrapLoaderConfiguration = new CallbackConfiguration(ClusterLinkCallbackFactory.INSTANCE, new Properties());
            defaultPortalCacheConfiguration = new PortalCacheConfiguration("DEFAULT_PORTAL_CACHE_NAME", cacheListenerConfigurations, bootstrapLoaderConfiguration);
        }
        return new PortalCacheManagerConfiguration(null, defaultPortalCacheConfiguration, null);
    }

    @Override
    protected void initPortalCacheManager() {
        if (this._name == null) {
            throw new NullPointerException("Name is null");
        }
        this._memoryPortalCaches = new ConcurrentHashMap<String, MemoryPortalCache<K, V>>(this._cacheManagerInitialCapacity);
        this.aggregatedCacheManagerListener.init();
    }
}

