/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memory;

import com.liferay.portal.kernel.cache.AbstractPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MemoryPortalCache<K extends Serializable, V>
extends AbstractPortalCache<K, V> {
    private ConcurrentMap<K, V> _concurrentMap;
    private String _name;
    private PortalCacheManager<K, V> _portalCacheManager;

    public MemoryPortalCache(PortalCacheManager<K, V> portalCacheManager, String name, int initialCapacity) {
        this._portalCacheManager = portalCacheManager;
        this._name = name;
        this._concurrentMap = new ConcurrentHashMap(initialCapacity);
    }

    public void destroy() {
        this.removeAll();
        this._concurrentMap = null;
        this._name = null;
    }

    public List<K> getKeys() {
        ArrayList<Serializable> keys = new ArrayList<Serializable>();
        for (Serializable key : this._concurrentMap.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    public String getName() {
        return this._name;
    }

    public PortalCacheManager<K, V> getPortalCacheManager() {
        return this._portalCacheManager;
    }

    public void removeAll() {
        this._concurrentMap.clear();
        this.aggregatedCacheListener.notifyRemoveAll((PortalCache)this);
    }

    protected V doGet(K key) {
        return this._concurrentMap.get(key);
    }

    protected void doPut(K key, V value, int timeToLive, boolean quiet) {
        V oldValue = this._concurrentMap.put(key, value);
        if (quiet) {
            return;
        }
        if (oldValue != null) {
            this.aggregatedCacheListener.notifyEntryUpdated((PortalCache)this, key, value, timeToLive);
        } else {
            this.aggregatedCacheListener.notifyEntryPut((PortalCache)this, key, value, timeToLive);
        }
    }

    protected V doPutIfAbsent(K key, V value, int timeToLive) {
        V oldValue = this._concurrentMap.putIfAbsent(key, value);
        if (oldValue == null) {
            this.aggregatedCacheListener.notifyEntryPut((PortalCache)this, key, value, timeToLive);
        }
        return oldValue;
    }

    protected void doRemove(K key) {
        Object value = this._concurrentMap.remove(key);
        if (value != null) {
            this.aggregatedCacheListener.notifyEntryRemoved((PortalCache)this, key, value, 0);
        }
    }

    protected boolean doRemove(K key, V value) {
        boolean removed = this._concurrentMap.remove(key, value);
        if (removed) {
            this.aggregatedCacheListener.notifyEntryRemoved((PortalCache)this, key, value, 0);
        }
        return removed;
    }

    protected V doReplace(K key, V value, int timeToLive) {
        V oldValue = this._concurrentMap.replace(key, value);
        if (oldValue != null) {
            this.aggregatedCacheListener.notifyEntryUpdated((PortalCache)this, key, value, timeToLive);
        }
        return oldValue;
    }

    protected boolean doReplace(K key, V oldValue, V newValue, int timeToLive) {
        boolean replaced = this._concurrentMap.replace(key, oldValue, newValue);
        if (replaced) {
            this.aggregatedCacheListener.notifyEntryUpdated((PortalCache)this, key, newValue, timeToLive);
        }
        return replaced;
    }
}

