/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.key;

import com.liferay.portal.cache.key.BaseCacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JavaMD5CacheKeyGenerator
extends BaseCacheKeyGenerator {
    private static final String _ALGORITHM_MD5 = "MD5";
    private static final boolean _CALLING_GET_CACHE_KEY_THREAD_SAFE = false;
    private static final char[] _HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Log _log = LogFactoryUtil.getLog(JavaMD5CacheKeyGenerator.class);
    private CharsetEncoder _charsetEncoder;
    private char[] _encodeBuffer = new char[32];
    private int _maxLength = -1;
    private MessageDigest _messageDigest;

    public JavaMD5CacheKeyGenerator() throws NoSuchAlgorithmException {
        this(-1);
    }

    public JavaMD5CacheKeyGenerator(int maxLength) throws NoSuchAlgorithmException {
        this._maxLength = maxLength;
        this._messageDigest = MessageDigest.getInstance(_ALGORITHM_MD5);
        this._charsetEncoder = CharsetEncoderUtil.getCharsetEncoder((String)"UTF-8");
    }

    @Override
    public CacheKeyGenerator clone() {
        try {
            return new JavaMD5CacheKeyGenerator(this._maxLength);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae.getMessage(), nsae);
        }
    }

    public String getCacheKey(String key) {
        if (this._maxLength > -1 && key.length() < this._maxLength) {
            return key;
        }
        try {
            this._messageDigest.update(this._charsetEncoder.encode(CharBuffer.wrap(key)));
            byte[] bytes = this._messageDigest.digest();
            return this.encodeCacheKey(bytes);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return key;
        }
    }

    public String getCacheKey(String[] keys) {
        return this.getCacheKey(new StringBundler(keys));
    }

    public String getCacheKey(StringBundler sb) {
        if (this._maxLength > -1 && sb.length() < this._maxLength) {
            return sb.toString();
        }
        try {
            String[] array = sb.getStrings();
            for (int i = 0; i < sb.index(); ++i) {
                String key = array[i];
                this._messageDigest.update(this._charsetEncoder.encode(CharBuffer.wrap(key)));
            }
            byte[] bytes = this._messageDigest.digest();
            return this.encodeCacheKey(bytes);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return sb.toString();
        }
    }

    @Override
    public boolean isCallingGetCacheKeyThreadSafe() {
        return false;
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    protected String encodeCacheKey(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            int value = bytes[i] & 0xFF;
            this._encodeBuffer[i * 2] = _HEX_CHARACTERS[value >> 4];
            this._encodeBuffer[i * 2 + 1] = _HEX_CHARACTERS[value & 0xF];
        }
        return new String(this._encodeBuffer);
    }
}

