/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.EhcachePortalCache;
import com.liferay.portal.cache.mvcc.MVCCPortalCache;
import com.liferay.portal.kernel.cache.LowLevelCache;
import com.liferay.portal.model.MVCCModel;
import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class LockBasedMVCCEhcachePortalCache<K extends Serializable, V extends MVCCModel>
extends MVCCPortalCache<K, V> {
    private Ehcache _ehcache;

    public LockBasedMVCCEhcachePortalCache(LowLevelCache<K, V> lowLevelCache) {
        super(lowLevelCache);
        if (!(lowLevelCache instanceof EhcachePortalCache)) {
            throw new IllegalArgumentException("LowLevelCache is not a EhcachePortalCache");
        }
        EhcachePortalCache ehcachePortalCache = (EhcachePortalCache)lowLevelCache;
        this._ehcache = ehcachePortalCache.ehcache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        this._ehcache.acquireWriteLockOnKey(key);
        try {
            super.remove(key);
        }
        finally {
            this._ehcache.releaseWriteLockOnKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPut(K key, V value, int timeToLive, boolean quiet) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        Element newElement = new Element(key, value);
        if (timeToLive > 0) {
            newElement.setTimeToLive(timeToLive);
        }
        this._ehcache.acquireWriteLockOnKey(key);
        try {
            Element oldElement = this._ehcache.get(key);
            if (oldElement == null) {
                this._ehcache.put(newElement, quiet);
                return;
            }
            MVCCModel oldValue = (MVCCModel)oldElement.getObjectValue();
            if (value.getMvccVersion() <= oldValue.getMvccVersion()) {
                return;
            }
            this._ehcache.put(newElement, quiet);
        }
        finally {
            this._ehcache.releaseWriteLockOnKey(key);
        }
    }
}

