/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.HtmlImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;

public class LiferayCacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static Log _log = LogFactoryUtil.getLog(LiferayCacheManagerPeerProviderFactory.class);
    private static HtmlImpl _htmlUtil = new HtmlImpl();
    private CacheManagerPeerProviderFactory _cacheManagerPeerProviderFactory;

    public LiferayCacheManagerPeerProviderFactory() {
        String className = PropsValues.EHCACHE_CACHE_MANAGER_PEER_PROVIDER_FACTORY;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Instantiating " + className + " " + ((Object)((Object)this)).hashCode()));
        }
        try {
            this._cacheManagerPeerProviderFactory = (CacheManagerPeerProviderFactory)InstanceFactory.newInstance((String)className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        Object[] keys;
        String portalPropertyKey = properties.getProperty("portalPropertyKey");
        if (Validator.isNull((String)portalPropertyKey)) {
            throw new RuntimeException("portalPropertyKey is null");
        }
        Properties propsUtilProperties = PropsUtil.getProperties();
        String portalPropertiesString = propsUtilProperties.getProperty(portalPropertyKey);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("portalPropertyKey " + portalPropertyKey + " has value " + portalPropertiesString));
        }
        portalPropertiesString = StringUtil.replace((String)portalPropertiesString, (char)',', (char)'\n');
        Properties portalProperties = null;
        try {
            portalProperties = PropertiesUtil.load((String)portalPropertiesString);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
            throw new RuntimeException(ioe.getMessage());
        }
        for (Object key : keys = portalProperties.keySet().toArray()) {
            String value = (String)portalProperties.remove(key);
            value = _htmlUtil.unescape(value);
            portalProperties.put(key, value);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)PropertiesUtil.list((Properties)portalProperties));
        }
        return this._cacheManagerPeerProviderFactory.createCachePeerProvider(cacheManager, portalProperties);
    }
}

