/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.LiferayCacheDecorator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.RegisteredEventListeners;

public class LiferayCacheManagerPeerListenerFactory
extends CacheManagerPeerListenerFactory {
    private static final CacheReplicator _PLACE_HOLDER = new CacheReplicator(){

        public boolean alive() {
            return true;
        }

        public Object clone() {
            return this;
        }

        public void dispose() {
        }

        public boolean isReplicateUpdatesViaCopy() {
            return false;
        }

        public boolean notAlive() {
            return false;
        }

        public void notifyElementEvicted(Ehcache ehcache, Element element) {
        }

        public void notifyElementExpired(Ehcache ehcache, Element element) {
        }

        public void notifyElementPut(Ehcache ehcache, Element element) {
        }

        public void notifyElementRemoved(Ehcache ehcache, Element element) {
        }

        public void notifyElementUpdated(Ehcache ehcache, Element element) {
        }

        public void notifyRemoveAll(Ehcache ehch) {
        }
    };
    private static Log _log = LogFactoryUtil.getLog(LiferayCacheManagerPeerListenerFactory.class);
    private final CacheManagerPeerListenerFactory _cacheManagerPeerListenerFactory;

    public LiferayCacheManagerPeerListenerFactory() {
        String className = PropsValues.EHCACHE_CACHE_MANAGER_PEER_LISTENER_FACTORY;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Instantiating " + className + " " + ((Object)((Object)this)).hashCode()));
        }
        try {
            this._cacheManagerPeerListenerFactory = (CacheManagerPeerListenerFactory)InstanceFactory.newInstance((String)className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CacheManagerPeerListener createCachePeerListener(CacheManager cacheManager, Properties properties) {
        CacheManagerPeerListener cacheManagerPeerListener = this._cacheManagerPeerListenerFactory.createCachePeerListener(cacheManager, properties);
        if (PropsValues.CLUSTER_LINK_ENABLED && !PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED) {
            return new LiferayCacheManagerPeerListener(cacheManager, cacheManagerPeerListener);
        }
        return cacheManagerPeerListener;
    }

    private static class LiferayCacheManagerPeerListener
    implements CacheManagerPeerListener {
        private final CacheManager _cacheManager;
        private final CacheManagerPeerListener _cacheManagerPeerListener;

        public LiferayCacheManagerPeerListener(CacheManager cacheManager, CacheManagerPeerListener cacheManagerPeerListener) {
            this._cacheManager = cacheManager;
            this._cacheManagerPeerListener = cacheManagerPeerListener;
        }

        public void attemptResolutionOfUniqueResourceConflict() throws CacheException, IllegalStateException {
            this._cacheManagerPeerListener.attemptResolutionOfUniqueResourceConflict();
        }

        public void dispose() {
            this._cacheManagerPeerListener.dispose();
        }

        public List getBoundCachePeers() {
            return this._cacheManagerPeerListener.getBoundCachePeers();
        }

        public String getScheme() {
            return this._cacheManagerPeerListener.getScheme();
        }

        public Status getStatus() {
            return this._cacheManagerPeerListener.getStatus();
        }

        public String getUniqueResourceIdentifier() {
            return this._cacheManagerPeerListener.getUniqueResourceIdentifier();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            for (String cacheName : this._cacheManager.getCacheNames()) {
                this._wrapEhcache(cacheName);
            }
            try {
                this._cacheManagerPeerListener.init();
            }
            finally {
                for (String cacheName : this._cacheManager.getCacheNames()) {
                    this._unwrapEhcache(cacheName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyCacheAdded(String cacheName) {
            this._wrapEhcache(cacheName);
            try {
                this._cacheManagerPeerListener.notifyCacheAdded(cacheName);
            }
            finally {
                this._unwrapEhcache(cacheName);
            }
        }

        public void notifyCacheRemoved(String cacheName) {
            this._cacheManagerPeerListener.notifyCacheRemoved(cacheName);
        }

        private void _unwrapEhcache(String cacheName) {
            Ehcache ehcache = this._cacheManager.getEhcache(cacheName);
            if (!(ehcache instanceof LiferayCacheDecorator)) {
                return;
            }
            LiferayCacheDecorator liferayCacheDecorator = (LiferayCacheDecorator)ehcache;
            this._cacheManager.replaceCacheWithDecoratedCache((Ehcache)liferayCacheDecorator, liferayCacheDecorator.getUnderlyingCache());
            RegisteredEventListeners registeredEventListeners = ehcache.getCacheEventNotificationService();
            registeredEventListeners.unregisterListener((CacheEventListener)_PLACE_HOLDER);
        }

        private void _wrapEhcache(String cacheName) {
            Ehcache ehcache = this._cacheManager.getEhcache(cacheName);
            if (!(ehcache instanceof LiferayCacheDecorator)) {
                this._cacheManager.replaceCacheWithDecoratedCache(ehcache, (Ehcache)new LiferayCacheDecorator(ehcache));
            }
            RegisteredEventListeners registeredEventListeners = ehcache.getCacheEventNotificationService();
            registeredEventListeners.registerListener((CacheEventListener)_PLACE_HOLDER);
        }
    }
}

