/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.JGroupsManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;

public class JGroupsCacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static final String _DEFAULT_CLUSTER_NAME = "Ehcache";
    private static Log _log = LogFactoryUtil.getLog(JGroupsCacheManagerPeerProviderFactory.class);

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        String channelProperties;
        String clusterName;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Creating JGroups peer provider");
        }
        if ((clusterName = properties.getProperty("clusterName")) == null) {
            clusterName = _DEFAULT_CLUSTER_NAME;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Cluster name " + clusterName));
        }
        if ((channelProperties = properties.getProperty("channelProperties")) != null && Validator.isNull((String)(channelProperties = StringUtil.replace((String)channelProperties, (String)" ", (String)"")))) {
            channelProperties = null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Channel properties " + channelProperties));
        }
        return new JGroupsManager(cacheManager, clusterName, channelProperties);
    }
}

