/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.AbstractPortalCacheManager;
import com.liferay.portal.cache.ehcache.CacheManagerUtil;
import com.liferay.portal.cache.ehcache.EhcacheConfigurationHelperUtil;
import com.liferay.portal.cache.ehcache.EhcachePortalCache;
import com.liferay.portal.cache.ehcache.PortalCacheManagerEventListener;
import com.liferay.portal.kernel.cache.CacheManagerListener;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanServer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.management.ManagementService;
import net.sf.ehcache.util.FailSafeTimer;

public class EhcachePortalCacheManager<K extends Serializable, V>
extends AbstractPortalCacheManager<K, V> {
    private static final String _DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE = "/ehcache/liferay-multi-vm-clustered.xml";
    private static Log _log = LogFactoryUtil.getLog(EhcachePortalCacheManager.class);
    private CacheManager _cacheManager;
    private String _configPropertyKey;
    private ObjectValuePair<Configuration, PortalCacheManagerConfiguration> _configurationPair;
    private ManagementService _managementService;
    private MBeanServer _mBeanServer;
    private String _name;
    private boolean _registerCacheConfigurations = true;
    private boolean _registerCacheManager = true;
    private boolean _registerCaches = true;
    private boolean _registerCacheStatistics = true;
    private boolean _usingDefault;

    public CacheManager getEhcacheManager() {
        return this._cacheManager;
    }

    public String getName() {
        return this._name;
    }

    public void reconfigureCaches(URL configurationURL) {
        this._configurationPair = EhcacheConfigurationHelperUtil.getConfiguration(configurationURL, this.clusterAware, this._usingDefault);
        Configuration ehcacheConfiguration = (Configuration)this._configurationPair.getKey();
        if (!this._name.equals(ehcacheConfiguration.getName())) {
            return;
        }
        this.reconfigEhcache(ehcacheConfiguration);
        this.reconfigPortalCache((PortalCacheManagerConfiguration)this._configurationPair.getValue());
    }

    public void setConfigPropertyKey(String configPropertyKey) {
        this._configPropertyKey = configPropertyKey;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this._mBeanServer = mBeanServer;
    }

    public void setRegisterCacheConfigurations(boolean registerCacheConfigurations) {
        this._registerCacheConfigurations = registerCacheConfigurations;
    }

    public void setRegisterCacheManager(boolean registerCacheManager) {
        this._registerCacheManager = registerCacheManager;
    }

    public void setRegisterCaches(boolean registerCaches) {
        this._registerCaches = registerCaches;
    }

    public void setRegisterCacheStatistics(boolean registerCacheStatistics) {
        this._registerCacheStatistics = registerCacheStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PortalCache<K, V> createPortalCache(String cacheName) {
        CacheManager cacheManager = this._cacheManager;
        synchronized (cacheManager) {
            if (!this._cacheManager.cacheExists(cacheName)) {
                this._cacheManager.addCache(cacheName);
            }
        }
        Cache cache = this._cacheManager.getCache(cacheName);
        return new EhcachePortalCache(this, (Ehcache)cache);
    }

    @Override
    protected void doClearAll() {
        this._cacheManager.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDestroy() {
        try {
            this._cacheManager.shutdown();
        }
        finally {
            if (this._managementService != null) {
                this._managementService.dispose();
            }
        }
    }

    @Override
    protected void doRemoveCache(String cacheName) {
        this._cacheManager.removeCache(cacheName);
    }

    @Override
    protected PortalCacheManagerConfiguration getPortalCacheManagerConfiguration() {
        return (PortalCacheManagerConfiguration)this._configurationPair.getValue();
    }

    @Override
    protected void initPortalCacheManager() {
        String configurationPath = PropsUtil.get(this._configPropertyKey);
        if (Validator.isNull((String)configurationPath)) {
            configurationPath = _DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE;
        }
        this._usingDefault = configurationPath.equals(_DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE);
        this._configurationPair = EhcacheConfigurationHelperUtil.getConfiguration(configurationPath, this.clusterAware, this._usingDefault);
        this._cacheManager = CacheManagerUtil.createCacheManager((Configuration)this._configurationPair.getKey());
        this._name = this._cacheManager.getName();
        FailSafeTimer failSafeTimer = this._cacheManager.getTimer();
        failSafeTimer.cancel();
        try {
            Field cacheManagerTimerField = ReflectionUtil.getDeclaredField(CacheManager.class, (String)"cacheManagerTimer");
            cacheManagerTimerField.set(this._cacheManager, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (PropsValues.EHCACHE_PORTAL_CACHE_MANAGER_JMX_ENABLED) {
            this._managementService = new ManagementService(this._cacheManager, this._mBeanServer, this._registerCacheManager, this._registerCaches, this._registerCacheConfigurations, this._registerCacheStatistics);
            this._managementService.init();
        }
        CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = this._cacheManager.getCacheManagerEventListenerRegistry();
        cacheManagerEventListenerRegistry.registerListener((CacheManagerEventListener)new PortalCacheManagerEventListener((CacheManagerListener)this.aggregatedCacheManagerListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconfigEhcache(Configuration configuration) {
        Map cacheConfigurations = configuration.getCacheConfigurations();
        for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
            String portalCacheName = cacheConfiguration.getName();
            CacheManager cacheManager = this._cacheManager;
            synchronized (cacheManager) {
                if (this._cacheManager.cacheExists(portalCacheName)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Overriding existing cache " + portalCacheName));
                    }
                    this._cacheManager.removeCache(portalCacheName);
                }
                Cache cache = new Cache(cacheConfiguration);
                this._cacheManager.addCache(cache);
            }
        }
    }
}

