/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.PortalCacheCacheEventListener;
import com.liferay.portal.kernel.cache.AbstractPortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.NotificationScope;
import net.sf.ehcache.event.RegisteredEventListeners;

public class EhcachePortalCache<K extends Serializable, V>
extends AbstractPortalCache<K, V> {
    protected Ehcache ehcache;
    private PortalCacheManager<K, V> _portalCacheManager;

    public EhcachePortalCache(PortalCacheManager<K, V> portalCacheManager, Ehcache ehcache) {
        this._portalCacheManager = portalCacheManager;
        this.ehcache = ehcache;
        RegisteredEventListeners registeredEventListeners = ehcache.getCacheEventNotificationService();
        registeredEventListeners.registerListener(new PortalCacheCacheEventListener(this.aggregatedCacheListener, this), NotificationScope.ALL);
    }

    public List<K> getKeys() {
        return this.ehcache.getKeys();
    }

    public String getName() {
        return this.ehcache.getName();
    }

    public PortalCacheManager<K, V> getPortalCacheManager() {
        return this._portalCacheManager;
    }

    public void removeAll() {
        this.ehcache.removeAll();
    }

    protected V doGet(K key) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            return null;
        }
        return (V)element.getObjectValue();
    }

    protected void doPut(K key, V value, int timeToLive, boolean quiet) {
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        if (quiet) {
            this.ehcache.putQuiet(element);
        } else {
            this.ehcache.put(element);
        }
    }

    protected V doPutIfAbsent(K key, V value, int timeToLive) {
        Element oldElement;
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        if ((oldElement = this.ehcache.putIfAbsent(element)) == null) {
            return null;
        }
        return (V)oldElement.getObjectValue();
    }

    protected void doRemove(K key) {
        this.ehcache.remove(key);
    }

    protected boolean doRemove(K key, V value) {
        Element element = new Element(key, value);
        return this.ehcache.removeElement(element);
    }

    protected V doReplace(K key, V value, int timeToLive) {
        Element oldElement;
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        if ((oldElement = this.ehcache.replace(element)) == null) {
            return null;
        }
        return (V)oldElement.getObjectValue();
    }

    protected boolean doReplace(K key, V oldValue, V newValue, int timeToLive) {
        Element oldElement = new Element(key, oldValue);
        Element newElement = new Element(key, newValue);
        if (timeToLive != 0) {
            newElement.setTimeToLive(timeToLive);
        }
        return this.ehcache.replace(oldElement, newElement);
    }
}

