/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.cluster.EhcachePortalCacheClusterReplicatorFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;

public class EhcacheConfigurationUtil {
    public static Configuration getConfiguration(String configurationPath) {
        return EhcacheConfigurationUtil.getConfiguration(configurationPath, false);
    }

    public static Configuration getConfiguration(String configurationPath, boolean clusterAware) {
        return EhcacheConfigurationUtil.getConfiguration(configurationPath, clusterAware, false);
    }

    public static Configuration getConfiguration(String configurationPath, boolean clusterAware, boolean usingDefault) {
        if (Validator.isNull((String)configurationPath)) {
            return null;
        }
        URL configurationURL = EhcacheConfigurationUtil.class.getResource(configurationPath);
        return EhcacheConfigurationUtil.getConfiguration(configurationURL, clusterAware, usingDefault);
    }

    public static Configuration getConfiguration(URL configurationURL) {
        return EhcacheConfigurationUtil.getConfiguration(configurationURL, false);
    }

    public static Configuration getConfiguration(URL configurationURL, boolean clusterAware) {
        return EhcacheConfigurationUtil.getConfiguration(configurationURL, clusterAware, false);
    }

    public static Configuration getConfiguration(URL configurationURL, boolean clusterAware, boolean usingDefault) {
        if (configurationURL == null) {
            return null;
        }
        Configuration configuration = ConfigurationFactory.parseConfiguration((URL)configurationURL);
        List<CacheConfiguration> cacheConfigurations = EhcacheConfigurationUtil._getAllCacheConfigurations(configuration);
        if (!PropsValues.EHCACHE_BOOTSTRAP_CACHE_LOADER_ENABLED) {
            EhcacheConfigurationUtil._clearBootstrapCacheLoaderConfigurations(cacheConfigurations);
        }
        if (!clusterAware || PropsValues.CLUSTER_LINK_ENABLED && !PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED) {
            return configuration;
        }
        EhcacheConfigurationUtil._configureEhcacheReplication(configuration, cacheConfigurations, usingDefault);
        return configuration;
    }

    private static void _clearBootstrapCacheLoaderConfigurations(List<CacheConfiguration> cacheConfigurations) {
        for (CacheConfiguration cacheConfiguration : cacheConfigurations) {
            cacheConfiguration.addBootstrapCacheLoaderFactory(null);
        }
    }

    private static String _clearCacheEventListenerConfigurations(CacheConfiguration cacheConfiguration, boolean usingDefault) {
        List cacheEventListenerConfigurations = cacheConfiguration.getCacheEventListenerConfigurations();
        ArrayList copyCacheEventListenerConfigurations = new ArrayList(cacheEventListenerConfigurations);
        if (usingDefault) {
            cacheEventListenerConfigurations.clear();
        }
        for (CacheConfiguration.CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration : copyCacheEventListenerConfigurations) {
            String fullyQualifiedClassPath = cacheEventListenerFactoryConfiguration.getFullyQualifiedClassPath();
            if (!fullyQualifiedClassPath.contains("LiferayCacheEventListenerFactory") && !fullyQualifiedClassPath.contains("net.sf.ehcache.distribution")) continue;
            cacheEventListenerConfigurations.remove(cacheEventListenerFactoryConfiguration);
            return cacheEventListenerFactoryConfiguration.getProperties();
        }
        return null;
    }

    private static void _configureEhcacheReplication(Configuration configuration, List<CacheConfiguration> cacheConfigurations, boolean usingDefault) {
        List factoryConfigurations = configuration.getCacheManagerPeerListenerFactoryConfigurations();
        factoryConfigurations.clear();
        factoryConfigurations = configuration.getCacheManagerPeerProviderFactoryConfiguration();
        factoryConfigurations.clear();
        for (CacheConfiguration cacheConfiguration : cacheConfigurations) {
            String properties = EhcacheConfigurationUtil._clearCacheEventListenerConfigurations(cacheConfiguration, usingDefault);
            if (properties == null || !PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED) continue;
            EhcacheConfigurationUtil._enableClusterLinkReplication(cacheConfiguration, properties);
        }
    }

    private static void _enableClusterLinkReplication(CacheConfiguration cacheConfiguration, String cacheEventListenerProperties) {
        CacheConfiguration.CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration = new CacheConfiguration.CacheEventListenerFactoryConfiguration();
        cacheEventListenerFactoryConfiguration.setClass(EhcachePortalCacheClusterReplicatorFactory.class.getName());
        cacheEventListenerFactoryConfiguration.setProperties(cacheEventListenerProperties);
        cacheConfiguration.addCacheEventListenerFactory(cacheEventListenerFactoryConfiguration);
    }

    private static List<CacheConfiguration> _getAllCacheConfigurations(Configuration configuration) {
        ArrayList<CacheConfiguration> cacheConfigurations = new ArrayList<CacheConfiguration>();
        CacheConfiguration defaultCacheConfiguration = configuration.getDefaultCacheConfiguration();
        if (defaultCacheConfiguration != null) {
            cacheConfigurations.add(defaultCacheConfiguration);
        }
        Map cacheConfigurationsMap = configuration.getCacheConfigurations();
        for (CacheConfiguration cacheConfiguration : cacheConfigurationsMap.values()) {
            cacheConfigurations.add(cacheConfiguration);
        }
        return cacheConfigurations;
    }
}

