/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.cluster.ClusterLinkCallbackFactory;
import com.liferay.portal.cache.ehcache.EhcacheCallbackFactory;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.configuration.CallbackConfiguration;
import com.liferay.portal.kernel.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.kernel.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.event.NotificationScope;

public class EhcacheConfigurationHelperUtil {
    public static ObjectValuePair<Configuration, PortalCacheManagerConfiguration> getConfiguration(String configurationPath) {
        return EhcacheConfigurationHelperUtil.getConfiguration(configurationPath, false, false);
    }

    public static ObjectValuePair<Configuration, PortalCacheManagerConfiguration> getConfiguration(String configurationPath, boolean clusterAware) {
        return EhcacheConfigurationHelperUtil.getConfiguration(configurationPath, clusterAware, false);
    }

    public static ObjectValuePair<Configuration, PortalCacheManagerConfiguration> getConfiguration(String configurationPath, boolean clusterAware, boolean usingDefault) {
        if (configurationPath == null) {
            throw new NullPointerException("Configuration path is null");
        }
        return EhcacheConfigurationHelperUtil.getConfiguration(EhcacheConfigurationHelperUtil.class.getResource(configurationPath), clusterAware, usingDefault);
    }

    public static ObjectValuePair<Configuration, PortalCacheManagerConfiguration> getConfiguration(URL configurationURL) {
        return EhcacheConfigurationHelperUtil.getConfiguration(configurationURL, false, false);
    }

    public static ObjectValuePair<Configuration, PortalCacheManagerConfiguration> getConfiguration(URL configurationURL, boolean clusterAware) {
        return EhcacheConfigurationHelperUtil.getConfiguration(configurationURL, clusterAware, false);
    }

    public static ObjectValuePair<Configuration, PortalCacheManagerConfiguration> getConfiguration(URL configurationURL, boolean clusterAware, boolean usingDefault) {
        if (configurationURL == null) {
            throw new NullPointerException("Configuration path is null");
        }
        Configuration ehcacheConfiguration = ConfigurationFactory.parseConfiguration((URL)configurationURL);
        List peerProviderConfiguration = ehcacheConfiguration.getCacheManagerPeerProviderFactoryConfiguration();
        if (!(peerProviderConfiguration.isEmpty() || clusterAware && PropsValues.CLUSTER_LINK_ENABLED && !PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED)) {
            peerProviderConfiguration.clear();
        }
        if (!((peerProviderConfiguration = ehcacheConfiguration.getCacheManagerPeerListenerFactoryConfigurations()).isEmpty() || clusterAware && PropsValues.CLUSTER_LINK_ENABLED && !PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED)) {
            peerProviderConfiguration.clear();
        }
        Set<CallbackConfiguration> cacheManagerListenerConfigurations = EhcacheConfigurationHelperUtil._getCacheManagerListenerConfigurations(ehcacheConfiguration);
        PortalCacheConfiguration defaultPortalCacheConfiguration = EhcacheConfigurationHelperUtil._parseCacheConfiguration(ehcacheConfiguration.getDefaultCacheConfiguration(), clusterAware, usingDefault);
        HashSet<PortalCacheConfiguration> portalCacheConfigurations = new HashSet<PortalCacheConfiguration>();
        Map cacheConfigurations = ehcacheConfiguration.getCacheConfigurations();
        for (Map.Entry entry : cacheConfigurations.entrySet()) {
            portalCacheConfigurations.add(EhcacheConfigurationHelperUtil._parseCacheConfiguration((CacheConfiguration)entry.getValue(), clusterAware, usingDefault));
        }
        PortalCacheManagerConfiguration portalCacheManagerConfiguration = new PortalCacheManagerConfiguration(cacheManagerListenerConfigurations, defaultPortalCacheConfiguration, portalCacheConfigurations);
        return new ObjectValuePair((Object)ehcacheConfiguration, (Object)portalCacheManagerConfiguration);
    }

    private static CacheListenerScope _getCacheListenerScope(NotificationScope notificationScope) {
        if (notificationScope == NotificationScope.ALL) {
            return CacheListenerScope.ALL;
        }
        if (notificationScope == NotificationScope.LOCAL) {
            return CacheListenerScope.LOCAL;
        }
        if (notificationScope == NotificationScope.REMOTE) {
            return CacheListenerScope.REMOTE;
        }
        throw new IllegalArgumentException("Unable to parse notification scope " + notificationScope);
    }

    private static Set<CallbackConfiguration> _getCacheManagerListenerConfigurations(Configuration ehcacheConfiguration) {
        FactoryConfiguration factoryConfiguration = ehcacheConfiguration.getCacheManagerEventListenerFactoryConfiguration();
        if (factoryConfiguration == null) {
            return Collections.emptySet();
        }
        Properties properties = EhcacheConfigurationHelperUtil._parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
        properties.put("CACHE_MANAGER_LISTENER_FACTORY_CLASS_NAME", factoryConfiguration.getFullyQualifiedClassPath());
        properties.put("PORTAL_CACHE_MANAGER_NAME", ehcacheConfiguration.getName());
        return Collections.singleton(new CallbackConfiguration(EhcacheCallbackFactory.INSTANCE, properties));
    }

    private static PortalCacheConfiguration _parseCacheConfiguration(CacheConfiguration cacheConfiguration, boolean clusterAware, boolean usingDefault) {
        String portalCacheName = cacheConfiguration.getName();
        if (portalCacheName == null) {
            portalCacheName = "DEFAULT_PORTAL_CACHE_NAME";
        }
        HashMap<CallbackConfiguration, CacheListenerScope> cacheListenerConfigurations = new HashMap<CallbackConfiguration, CacheListenerScope>();
        List cacheEventListenerConfigurations = cacheConfiguration.getCacheEventListenerConfigurations();
        for (CacheConfiguration.CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration : cacheEventListenerConfigurations) {
            String fullyQualifiedClassPath = cacheEventListenerFactoryConfiguration.getFullyQualifiedClassPath();
            Properties properties = EhcacheConfigurationHelperUtil._parseProperties(cacheEventListenerFactoryConfiguration.getProperties(), cacheEventListenerFactoryConfiguration.getPropertySeparator());
            CacheListenerScope cacheListenerScope = EhcacheConfigurationHelperUtil._getCacheListenerScope(cacheEventListenerFactoryConfiguration.getListenFor());
            if (fullyQualifiedClassPath.contains("LiferayCacheEventListenerFactory") || fullyQualifiedClassPath.contains("net.sf.ehcache.distribution")) {
                if (!clusterAware || !PropsValues.CLUSTER_LINK_ENABLED) continue;
                if (PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED) {
                    cacheListenerConfigurations.put(new CallbackConfiguration(ClusterLinkCallbackFactory.INSTANCE, properties), cacheListenerScope);
                    continue;
                }
                properties.put("CACHE_EVENT_LISTENER_FACTORY_CLASS_NAME", cacheEventListenerFactoryConfiguration.getFullyQualifiedClassPath());
                cacheListenerConfigurations.put(new CallbackConfiguration(EhcacheCallbackFactory.INSTANCE, properties), cacheListenerScope);
                continue;
            }
            if (usingDefault) continue;
            properties.put("CACHE_EVENT_LISTENER_FACTORY_CLASS_NAME", cacheEventListenerFactoryConfiguration.getFullyQualifiedClassPath());
            cacheListenerConfigurations.put(new CallbackConfiguration(EhcacheCallbackFactory.INSTANCE, properties), cacheListenerScope);
        }
        cacheEventListenerConfigurations.clear();
        CallbackConfiguration bootstrapLoaderConfiguration = null;
        CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration = cacheConfiguration.getBootstrapCacheLoaderFactoryConfiguration();
        if (bootstrapCacheLoaderFactoryConfiguration != null) {
            Properties properties = EhcacheConfigurationHelperUtil._parseProperties(bootstrapCacheLoaderFactoryConfiguration.getProperties(), bootstrapCacheLoaderFactoryConfiguration.getPropertySeparator());
            if (clusterAware && PropsValues.CLUSTER_LINK_ENABLED) {
                if (PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED) {
                    bootstrapLoaderConfiguration = new CallbackConfiguration(ClusterLinkCallbackFactory.INSTANCE, properties);
                } else {
                    properties.put("BOOTSTRAP_CACHE_LOADER_FACTORY_CLASS_NAME", bootstrapCacheLoaderFactoryConfiguration.getFullyQualifiedClassPath());
                    bootstrapLoaderConfiguration = new CallbackConfiguration(EhcacheCallbackFactory.INSTANCE, properties);
                }
            }
            cacheConfiguration.addBootstrapCacheLoaderFactory(null);
        }
        return new PortalCacheConfiguration(portalCacheName, cacheListenerConfigurations, bootstrapLoaderConfiguration);
    }

    private static Properties _parseProperties(String propertiesString, String propertySeparator) {
        Properties properties = new Properties();
        if (propertiesString == null) {
            return properties;
        }
        if (propertySeparator == null) {
            propertySeparator = ",";
        }
        String propertyLines = propertiesString.trim();
        propertyLines = StringUtil.replace((String)propertyLines, (String)propertySeparator, (String)"\n");
        try {
            properties.load((Reader)new UnsyncStringReader(propertyLines));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return properties;
    }
}

