/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.EhcacheBootstrapLoaderAdapter;
import com.liferay.portal.cache.ehcache.EhcacheCacheListenerAdapter;
import com.liferay.portal.cache.ehcache.EhcacheCacheManagerListenerAdapter;
import com.liferay.portal.cache.ehcache.EhcacheCacheReplicatorAdapter;
import com.liferay.portal.cache.ehcache.EhcachePortalCacheManager;
import com.liferay.portal.kernel.cache.BootstrapLoader;
import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheManagerListener;
import com.liferay.portal.kernel.cache.CallbackFactory;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.ClassLoaderUtil;
import java.io.Serializable;
import java.util.Properties;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.event.CacheManagerEventListenerFactory;

public class EhcacheCallbackFactory
implements CallbackFactory {
    public static final CallbackFactory INSTANCE = new EhcacheCallbackFactory();
    private static Log _log = LogFactoryUtil.getLog(EhcacheCallbackFactory.class);

    public BootstrapLoader createBootstrapLoader(Properties properties) {
        String className = properties.getProperty("BOOTSTRAP_CACHE_LOADER_FACTORY_CLASS_NAME");
        if (Validator.isNull((String)className)) {
            return null;
        }
        try {
            BootstrapCacheLoaderFactory bootstrapCacheLoaderFactory = (BootstrapCacheLoaderFactory)InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)className);
            return new EhcacheBootstrapLoaderAdapter(bootstrapCacheLoaderFactory.createBootstrapCacheLoader(properties));
        }
        catch (Exception e) {
            _log.error((Object)("Unable to instantiate bootstrap cache loader factory " + className), (Throwable)e);
            return null;
        }
    }

    public <K extends Serializable, V> CacheListener<K, V> createCacheListener(Properties properties) {
        String className = properties.getProperty("CACHE_EVENT_LISTENER_FACTORY_CLASS_NAME");
        if (Validator.isNull((String)className)) {
            return null;
        }
        try {
            CacheEventListenerFactory cacheEventListenerFactory = (CacheEventListenerFactory)InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)className);
            CacheEventListener cacheEventListener = cacheEventListenerFactory.createCacheEventListener(properties);
            if (cacheEventListener instanceof CacheReplicator) {
                return new EhcacheCacheReplicatorAdapter(cacheEventListener);
            }
            return new EhcacheCacheListenerAdapter(cacheEventListener);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to instantiate cache event listener factory " + className), (Throwable)e);
            return null;
        }
    }

    public CacheManagerListener createCacheManagerListener(Properties properties) {
        String className = properties.getProperty("CACHE_MANAGER_LISTENER_FACTORY_CLASS_NAME");
        if (Validator.isNull((String)className)) {
            return null;
        }
        String portalCacheManagerName = properties.getProperty("PORTAL_CACHE_MANAGER_NAME");
        if (Validator.isNull((String)portalCacheManagerName)) {
            return null;
        }
        PortalCacheManager portalCacheManager = PortalCacheProvider.getPortalCacheManager((String)portalCacheManagerName);
        if (!(portalCacheManager instanceof EhcachePortalCacheManager)) {
            throw new IllegalArgumentException("PortalCacheManager with name " + portalCacheManagerName + " is not a " + EhcachePortalCacheManager.class.getName());
        }
        EhcachePortalCacheManager ehcachePortalCacheManager = (EhcachePortalCacheManager)portalCacheManager;
        try {
            CacheManagerEventListenerFactory cacheManagerEventListenerFactory = (CacheManagerEventListenerFactory)InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)className);
            return new EhcacheCacheManagerListenerAdapter(cacheManagerEventListenerFactory.createCacheManagerEventListener(ehcachePortalCacheManager.getEhcacheManager(), properties));
        }
        catch (Exception e) {
            _log.error((Object)("Unable to instantiate cache manager event listener factory " + className), (Throwable)e);
            return null;
        }
    }

    private EhcacheCallbackFactory() {
    }
}

