/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.EhcacheUnwrapUtil;
import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import java.io.Serializable;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class EhcacheCacheListenerAdapter<K extends Serializable, V>
implements CacheListener<K, V> {
    private final CacheEventListener _cacheEventListener;

    public EhcacheCacheListenerAdapter(CacheEventListener cacheEventListener) {
        this._cacheEventListener = cacheEventListener;
    }

    public void notifyEntryEvicted(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this._cacheEventListener.notifyElementEvicted(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyEntryExpired(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this._cacheEventListener.notifyElementExpired(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyEntryPut(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this._cacheEventListener.notifyElementPut(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyEntryRemoved(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this._cacheEventListener.notifyElementRemoved(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyEntryUpdated(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this._cacheEventListener.notifyElementUpdated(EhcacheUnwrapUtil.getEhcache(portalCache), element);
    }

    public void notifyRemoveAll(PortalCache<K, V> portalCache) throws PortalCacheException {
        this._cacheEventListener.notifyRemoveAll(EhcacheUnwrapUtil.getEhcache(portalCache));
    }
}

