/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.EhcacheUnwrapUtil;
import com.liferay.portal.kernel.cache.BootstrapLoader;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;

public class EhcacheBootstrapLoaderAdapter
implements BootstrapLoader {
    private static Log _log = LogFactoryUtil.getLog(EhcacheBootstrapLoaderAdapter.class);
    private final BootstrapCacheLoader _bootstrapCacheLoader;

    public EhcacheBootstrapLoaderAdapter(BootstrapCacheLoader bootstrapCacheLoader) {
        this._bootstrapCacheLoader = bootstrapCacheLoader;
    }

    public boolean isAsynchronous() {
        return this._bootstrapCacheLoader.isAsynchronous();
    }

    public void load(String portalCacheManagerName, String portalCacheName) {
        PortalCacheManager portalCacheManager = PortalCacheProvider.getPortalCacheManager((String)portalCacheManagerName);
        if (!portalCacheManager.isClusterAware()) {
            _log.error((Object)("Unable to load cache within cache manager " + portalCacheManagerName));
            return;
        }
        PortalCache portalCache = portalCacheManager.getCache(portalCacheName);
        this._bootstrapCacheLoader.load(EhcacheUnwrapUtil.getEhcache(portalCache));
    }
}

