/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Field;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;

public class CacheManagerUtil {
    private static final Field _STATISTICS_EXECUTOR_FIELD;

    public static CacheManager createCacheManager(Configuration configuration) {
        CacheManager cacheManager = new CacheManager(configuration);
        try {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)_STATISTICS_EXECUTOR_FIELD.get(cacheManager);
            scheduledThreadPoolExecutor.setCorePoolSize(PropsValues.EHCACHE_CACHE_MANAGER_STATISTICS_THREAD_POOL_SIZE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cacheManager;
    }

    static {
        try {
            _STATISTICS_EXECUTOR_FIELD = ReflectionUtil.getDeclaredField(CacheManager.class, (String)"statisticsExecutor");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

