/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.configurator.impl;

import com.liferay.portal.cache.configurator.PortalCacheConfigurator;
import com.liferay.portal.dao.orm.hibernate.region.LiferayEhcacheRegionFactory;
import com.liferay.portal.dao.orm.hibernate.region.SingletonLiferayEhcacheRegionFactory;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.ClassLoaderUtil;
import java.net.URL;
import java.util.Collection;

public class PortalCacheConfiguratorImpl
implements PortalCacheConfigurator {
    private static Log _log = LogFactoryUtil.getLog(PortalCacheConfiguratorImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigureCaches(ClassLoader classLoader, URL url) throws Exception {
        if (Validator.isNull((Object)url)) {
            return;
        }
        ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader[])new ClassLoader[]{ClassLoaderUtil.getPortalClassLoader(), classLoader});
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoaderUtil.setContextClassLoader(aggregateClassLoader);
            Collection portalCacheManagers = PortalCacheProvider.getPortalCacheManagers();
            for (PortalCacheManager portalCacheManager : portalCacheManagers) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Reconfiguring caches in cache manager " + portalCacheManager.getName() + " using " + url));
                }
                portalCacheManager.reconfigureCaches(url);
            }
        }
        finally {
            ClassLoaderUtil.setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public void reconfigureHibernateCache(URL url) {
        if (Validator.isNull((Object)url)) {
            return;
        }
        LiferayEhcacheRegionFactory liferayEhcacheRegionFactory = SingletonLiferayEhcacheRegionFactory.getInstance();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Reconfiguring Hibernate caches using " + url));
        }
        liferayEhcacheRegionFactory.reconfigureCaches(url);
    }
}

