/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.cluster.clusterlink.messaging;

import com.liferay.portal.kernel.cache.AggregatedCacheListener;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheProvider;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEvent;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEventType;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class ClusterLinkPortalCacheClusterListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(ClusterLinkPortalCacheClusterListener.class);

    protected void doReceive(Message message) throws Exception {
        byte[] data = (byte[])message.getPayload();
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(data));
        PortalCacheClusterEvent portalCacheClusterEvent = (PortalCacheClusterEvent)deserializer.readObject();
        if (portalCacheClusterEvent == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Payload is null");
            }
            return;
        }
        this.handlePortalCacheClusterEvent(portalCacheClusterEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePortalCacheClusterEvent(PortalCacheClusterEvent portalCacheClusterEvent) {
        PortalCacheManager portalCacheManager = PortalCacheProvider.getPortalCacheManager((String)portalCacheClusterEvent.getPortalCacheManagerName());
        PortalCache portalCache = portalCacheManager.getCache(portalCacheClusterEvent.getPortalCacheName());
        if (portalCache == null) {
            return;
        }
        PortalCacheClusterEventType portalCacheClusterEventType = portalCacheClusterEvent.getEventType();
        boolean remoteInvoke = AggregatedCacheListener.isRemoteInvoke();
        AggregatedCacheListener.setRemoteInvoke((boolean)true);
        try {
            if (portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.REMOVE_ALL)) {
                portalCache.removeAll();
            } else if (portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.PUT) || portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.UPDATE)) {
                Serializable key = portalCacheClusterEvent.getElementKey();
                Serializable value = portalCacheClusterEvent.getElementValue();
                if (value == null) {
                    portalCache.remove(key);
                } else {
                    portalCache.put(key, (Object)value, portalCacheClusterEvent.getTimeToLive());
                }
            } else {
                portalCache.remove(portalCacheClusterEvent.getElementKey());
            }
        }
        finally {
            AggregatedCacheListener.setRemoteInvoke((boolean)remoteInvoke);
        }
    }
}

