/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.cluster;

import com.liferay.portal.cache.cluster.ClusterReplicationThreadLocal;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEvent;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEventType;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterLinkUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class EhcachePortalCacheClusterReplicator
implements CacheEventListener {
    private static final String _REPLICATE_PUTS = "replicatePuts";
    private static final String _REPLICATE_PUTS_VIA_COPY = "replicatePutsViaCopy";
    private static final String _REPLICATE_REMOVALS = "replicateRemovals";
    private static final String _REPLICATE_UPDATES = "replicateUpdates";
    private static final String _REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private final boolean _replicatePuts;
    private final boolean _replicatePutsViaCopy;
    private final boolean _replicateRemovals;
    private final boolean _replicateUpdates;
    private final boolean _replicateUpdatesViaCopy;

    public EhcachePortalCacheClusterReplicator(Properties properties) {
        if (properties != null) {
            this._replicatePuts = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_PUTS), (boolean)true);
            this._replicatePutsViaCopy = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_PUTS_VIA_COPY));
            this._replicateRemovals = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_REMOVALS), (boolean)true);
            this._replicateUpdates = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_UPDATES), (boolean)true);
            this._replicateUpdatesViaCopy = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_UPDATES_VIA_COPY));
        } else {
            this._replicatePuts = true;
            this._replicatePutsViaCopy = false;
            this._replicateRemovals = true;
            this._replicateUpdates = true;
            this._replicateUpdatesViaCopy = false;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void dispose() {
    }

    public void notifyElementEvicted(Ehcache ehcache, Element element) {
    }

    public void notifyElementExpired(Ehcache ehcache, Element element) {
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        if (!this._replicatePuts || !ClusterReplicationThreadLocal.isReplicate()) {
            return;
        }
        CacheManager cacheManager = ehcache.getCacheManager();
        Serializable key = (Serializable)element.getObjectKey();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(cacheManager.getName(), ehcache.getName(), key, PortalCacheClusterEventType.PUT);
        if (this._replicatePutsViaCopy) {
            portalCacheClusterEvent.setElementValue((Serializable)element.getObjectValue());
            portalCacheClusterEvent.setTimeToLive(element.getTimeToLive());
        }
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }

    public void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
        if (!this._replicateRemovals || !ClusterReplicationThreadLocal.isReplicate()) {
            return;
        }
        CacheManager cacheManager = ehcache.getCacheManager();
        Serializable key = (Serializable)element.getObjectKey();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(cacheManager.getName(), ehcache.getName(), key, PortalCacheClusterEventType.REMOVE);
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        if (!this._replicateUpdates || !ClusterReplicationThreadLocal.isReplicate()) {
            return;
        }
        Serializable key = (Serializable)element.getObjectKey();
        CacheManager cacheManager = ehcache.getCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(cacheManager.getName(), ehcache.getName(), key, PortalCacheClusterEventType.UPDATE);
        if (this._replicateUpdatesViaCopy) {
            portalCacheClusterEvent.setElementValue((Serializable)element.getObjectValue());
            portalCacheClusterEvent.setTimeToLive(element.getTimeToLive());
        }
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }

    public void notifyRemoveAll(Ehcache ehcache) {
        if (!this._replicateRemovals || !ClusterReplicationThreadLocal.isReplicate()) {
            return;
        }
        CacheManager cacheManager = ehcache.getCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(cacheManager.getName(), ehcache.getName(), null, PortalCacheClusterEventType.REMOVE_ALL);
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }
}

