/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.cluster;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheReplicator;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEvent;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEventType;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterLinkUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.util.Properties;

public class ClusterLinkCacheReplicator<K extends Serializable, V extends Serializable>
implements CacheListener<K, V>,
CacheReplicator {
    private static final String _REPLICATE_PUTS = "replicatePuts";
    private static final String _REPLICATE_PUTS_VIA_COPY = "replicatePutsViaCopy";
    private static final String _REPLICATE_REMOVALS = "replicateRemovals";
    private static final String _REPLICATE_UPDATES = "replicateUpdates";
    private static final String _REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private final boolean _replicatePuts;
    private final boolean _replicatePutsViaCopy;
    private final boolean _replicateRemovals;
    private final boolean _replicateUpdates;
    private final boolean _replicateUpdatesViaCopy;

    public ClusterLinkCacheReplicator(Properties properties) {
        if (properties != null) {
            this._replicatePuts = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_PUTS), (boolean)true);
            this._replicatePutsViaCopy = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_PUTS_VIA_COPY));
            this._replicateRemovals = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_REMOVALS), (boolean)true);
            this._replicateUpdates = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_UPDATES), (boolean)true);
            this._replicateUpdatesViaCopy = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_UPDATES_VIA_COPY));
        } else {
            this._replicatePuts = true;
            this._replicatePutsViaCopy = false;
            this._replicateRemovals = true;
            this._replicateUpdates = true;
            this._replicateUpdatesViaCopy = false;
        }
    }

    public void notifyEntryEvicted(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
    }

    public void notifyEntryExpired(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
    }

    public void notifyEntryPut(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        if (!this._replicatePuts) {
            return;
        }
        PortalCacheManager portalCacheManager = portalCache.getPortalCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(portalCacheManager.getName(), portalCache.getName(), key, PortalCacheClusterEventType.PUT);
        if (this._replicatePutsViaCopy) {
            portalCacheClusterEvent.setElementValue(value);
            portalCacheClusterEvent.setTimeToLive(timeToLive);
        }
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }

    public void notifyEntryRemoved(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        if (!this._replicateRemovals) {
            return;
        }
        PortalCacheManager portalCacheManager = portalCache.getPortalCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(portalCacheManager.getName(), portalCache.getName(), key, PortalCacheClusterEventType.REMOVE);
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }

    public void notifyEntryUpdated(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        if (!this._replicateUpdates) {
            return;
        }
        PortalCacheManager portalCacheManager = portalCache.getPortalCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(portalCacheManager.getName(), portalCache.getName(), key, PortalCacheClusterEventType.UPDATE);
        if (this._replicateUpdatesViaCopy) {
            portalCacheClusterEvent.setElementValue(value);
            portalCacheClusterEvent.setTimeToLive(timeToLive);
        }
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }

    public void notifyRemoveAll(PortalCache<K, V> portalCache) throws PortalCacheException {
        if (!this._replicateRemovals) {
            return;
        }
        PortalCacheManager portalCacheManager = portalCache.getPortalCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(portalCacheManager.getName(), portalCache.getName(), null, PortalCacheClusterEventType.REMOVE_ALL);
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }
}

