/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.bootstrap;

import com.liferay.portal.cache.bootstrap.ClusterLinkBootstrapLoaderHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;

public class EhcacheStreamBootstrapCacheLoader
implements BootstrapCacheLoader {
    private static Log _log = LogFactoryUtil.getLog(EhcacheStreamBootstrapCacheLoader.class);
    private final boolean _bootstrapAsynchronously;

    public EhcacheStreamBootstrapCacheLoader(Properties properties) {
        this._bootstrapAsynchronously = properties != null ? GetterUtil.getBoolean((String)properties.getProperty("bootstrapAsynchronously")) : true;
    }

    public Object clone() {
        return this;
    }

    public void doLoad(Ehcache ehcache) {
        block3: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Bootstraping " + ehcache.getName()));
            }
            CacheManager cacheManager = ehcache.getCacheManager();
            try {
                ClusterLinkBootstrapLoaderHelperUtil.loadCachesFromCluster(cacheManager.getName(), ehcache.getName());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to load cache data from the cluster", (Throwable)e);
            }
        }
    }

    public boolean isAsynchronous() {
        return this._bootstrapAsynchronously;
    }

    public void load(Ehcache ehcache) {
        if (ClusterLinkBootstrapLoaderHelperUtil.isSkipped()) {
            return;
        }
        if (this._bootstrapAsynchronously) {
            EhcacheStreamClientThread streamBootstrapThread = new EhcacheStreamClientThread(ehcache);
            streamBootstrapThread.start();
        } else {
            this.doLoad(ehcache);
        }
    }

    private class EhcacheStreamClientThread
    extends Thread {
        private Ehcache _ehcache;

        public EhcacheStreamClientThread(Ehcache ehcache) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ehcache stream client thread for cache " + ehcache.getName()));
            }
            this._ehcache = ehcache;
            this.setDaemon(true);
            this.setName(EhcacheStreamClientThread.class.getName() + " - " + ehcache.getName());
            this.setPriority(5);
        }

        @Override
        public void run() {
            block2: {
                try {
                    EhcacheStreamBootstrapCacheLoader.this.doLoad(this._ehcache);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)"Unable to asynchronously stream bootstrap", (Throwable)e);
                }
            }
        }
    }
}

