/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.cache.transactional.TransactionalPortalCache;
import com.liferay.portal.kernel.cache.AggregatedCacheManagerListener;
import com.liferay.portal.kernel.cache.BootstrapLoader;
import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.CacheManagerListener;
import com.liferay.portal.kernel.cache.CallbackFactory;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheProvider;
import com.liferay.portal.kernel.cache.configuration.CallbackConfiguration;
import com.liferay.portal.kernel.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.kernel.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractPortalCacheManager<K extends Serializable, V>
implements PortalCacheManager<K, V> {
    protected final AggregatedCacheManagerListener aggregatedCacheManagerListener = new AggregatedCacheManagerListener();
    protected boolean clusterAware;
    private boolean _mpiOnly;
    private PortalCacheManagerConfiguration _portalCacheManagerConfiguration;
    private final ConcurrentMap<String, PortalCache<K, V>> _portalCaches = new ConcurrentHashMap<String, PortalCache<K, V>>();

    public void afterPropertiesSet() {
        if (this._portalCacheManagerConfiguration != null || this._mpiOnly && SPIUtil.isSPI()) {
            return;
        }
        this.initPortalCacheManager();
        this._portalCacheManagerConfiguration = this.getPortalCacheManagerConfiguration();
        for (CallbackConfiguration callbackConfiguration : this._portalCacheManagerConfiguration.getCacheManagerListenerConfigurations()) {
            CallbackFactory callbackFactory = callbackConfiguration.getCallbackFactory();
            CacheManagerListener cacheManagerListener = callbackFactory.createCacheManagerListener(callbackConfiguration.getProperties());
            if (cacheManagerListener == null) continue;
            this.registerCacheManagerListener(cacheManagerListener);
        }
        PortalCacheProvider.registerPortalCacheManager((PortalCacheManager)this);
    }

    public void clearAll() throws PortalCacheException {
        this._portalCaches.clear();
        this.doClearAll();
    }

    public void destroy() {
        PortalCacheProvider.unregisterPortalCacheManager((String)this.getName());
        this._portalCaches.clear();
        this.doDestroy();
    }

    public PortalCache<K, V> getCache(String name) throws PortalCacheException {
        return this.getCache(name, false);
    }

    public PortalCache<K, V> getCache(String name, boolean blocking) throws PortalCacheException {
        CallbackFactory callbackFactory;
        BootstrapLoader bootstrapLoader;
        CallbackConfiguration bootstrapLoaderConfiguration;
        PortalCache<K, V> previousPortalCache;
        PortalCache<K, V> portalCache = (PortalCache<K, V>)this._portalCaches.get(name);
        if (portalCache != null) {
            return portalCache;
        }
        portalCache = this.createPortalCache(name);
        PortalCacheConfiguration portalCacheConfiguration = this._portalCacheManagerConfiguration.getPortalCacheConfiguration(portalCache.getName());
        if (portalCacheConfiguration == null) {
            portalCacheConfiguration = this._portalCacheManagerConfiguration.getDefaultPortalCacheConfiguration();
        }
        this._initPortalCacheListeners(portalCache, portalCacheConfiguration);
        if (PropsValues.TRANSACTIONAL_CACHE_ENABLED && this.isTransactionalPortalCache(name)) {
            portalCache = new TransactionalPortalCache<K, V>(portalCache);
        }
        if (PropsValues.EHCACHE_BLOCKING_CACHE_ALLOWED && blocking) {
            portalCache = new PortalCache<K, V>(portalCache);
        }
        if ((previousPortalCache = this._portalCaches.putIfAbsent(name, portalCache)) != null) {
            portalCache = previousPortalCache;
        } else if (PropsValues.EHCACHE_BOOTSTRAP_CACHE_LOADER_ENABLED && portalCacheConfiguration != null && (bootstrapLoaderConfiguration = portalCacheConfiguration.getBootstrapLoaderConfiguration()) != null && (bootstrapLoader = (callbackFactory = bootstrapLoaderConfiguration.getCallbackFactory()).createBootstrapLoader(bootstrapLoaderConfiguration.getProperties())) != null) {
            bootstrapLoader.load(this.getName(), name);
        }
        return portalCache;
    }

    public Set<CacheManagerListener> getCacheManagerListeners() {
        return this.aggregatedCacheManagerListener.getCacheManagerListeners();
    }

    public boolean isClusterAware() {
        return this.clusterAware;
    }

    public boolean registerCacheManagerListener(CacheManagerListener cacheManagerListener) {
        return this.aggregatedCacheManagerListener.addCacheListener(cacheManagerListener);
    }

    public void removeCache(String name) {
        this._portalCaches.remove(name);
        this.doRemoveCache(name);
    }

    public void setClusterAware(boolean clusterAware) {
        this.clusterAware = clusterAware;
    }

    public void setMpiOnly(boolean mpiOnly) {
        this._mpiOnly = mpiOnly;
    }

    public boolean unregisterCacheManagerListener(CacheManagerListener cacheManagerListener) {
        return this.aggregatedCacheManagerListener.removeCacheListener(cacheManagerListener);
    }

    public void unregisterCacheManagerListeners() {
        this.aggregatedCacheManagerListener.clearAll();
    }

    protected abstract PortalCache<K, V> createPortalCache(String var1);

    protected abstract void doClearAll();

    protected abstract void doDestroy();

    protected abstract void doRemoveCache(String var1);

    protected abstract PortalCacheManagerConfiguration getPortalCacheManagerConfiguration();

    protected abstract void initPortalCacheManager();

    protected boolean isTransactionalPortalCache(String name) {
        for (String namePattern : PropsValues.TRANSACTIONAL_CACHE_NAMES) {
            if (!StringUtil.wildcardMatches((String)name, (String)namePattern, (char)'?', (char)'*', (char)'%', (boolean)true)) continue;
            return true;
        }
        return false;
    }

    protected void reconfigPortalCache(PortalCacheManagerConfiguration portalCacheManagerConfiguration) {
        for (String portalCacheName : portalCacheManagerConfiguration.getPortalCacheNames()) {
            PortalCache portalCache = (PortalCache)this._portalCaches.get(portalCacheName);
            if (portalCache == null) continue;
            portalCache.unregisterCacheListeners();
            this._initPortalCacheListeners(portalCache, portalCacheManagerConfiguration.getPortalCacheConfiguration(portalCacheName));
        }
    }

    private void _initPortalCacheListeners(PortalCache<K, V> portalCache, PortalCacheConfiguration portalCacheConfiguration) {
        if (portalCacheConfiguration == null) {
            return;
        }
        Map cacheListenerConfigurations = portalCacheConfiguration.getCacheListenerConfigurations();
        for (Map.Entry entry : cacheListenerConfigurations.entrySet()) {
            CallbackConfiguration callbackConfiguration = (CallbackConfiguration)entry.getKey();
            CallbackFactory callbackFactory = callbackConfiguration.getCallbackFactory();
            CacheListener cacheListener = callbackFactory.createCacheListener(callbackConfiguration.getProperties());
            portalCache.registerCacheListener(cacheListener, (CacheListenerScope)entry.getValue());
        }
    }
}

