/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.backgroundtask.messaging;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.backgroundtask.messaging.BackgroundTaskStatusMessageListener;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistryUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.backgroundtask.ClassLoaderAwareBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.SerialBackgroundTaskExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.ClassLoaderUtil;

public class BackgroundTaskMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(BackgroundTaskMessageListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doReceive(Message message) throws Exception {
        block15: {
            long backgroundTaskId = (Long)message.get("backgroundTaskId");
            BackgroundTaskThreadLocal.setBackgroundTaskId((long)backgroundTaskId);
            ServiceContext serviceContext = new ServiceContext();
            BackgroundTask backgroundTask = BackgroundTaskLocalServiceUtil.amendBackgroundTask((long)backgroundTaskId, null, (int)1, (ServiceContext)serviceContext);
            if (backgroundTask == null) {
                return;
            }
            BackgroundTaskExecutor backgroundTaskExecutor = null;
            BackgroundTaskStatusMessageListener backgroundTaskStatusMessageListener = null;
            int status = backgroundTask.getStatus();
            String statusMessage = null;
            try {
                ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
                String servletContextNames = backgroundTask.getServletContextNames();
                if (Validator.isNotNull((String)servletContextNames)) {
                    classLoader = ClassLoaderUtil.getAggregatePluginsClassLoader(StringUtil.split((String)servletContextNames), false);
                }
                backgroundTaskExecutor = (BackgroundTaskExecutor)InstanceFactory.newInstance((ClassLoader)classLoader, (String)backgroundTask.getTaskExecutorClassName());
                backgroundTaskExecutor = this.wrapBackgroundTaskExecutor(backgroundTaskExecutor, classLoader);
                BackgroundTaskStatusRegistryUtil.registerBackgroundTaskStatus((long)backgroundTaskId);
                BackgroundTaskStatusMessageTranslator backgroundTaskStatusMessageTranslator = backgroundTaskExecutor.getBackgroundTaskStatusMessageTranslator();
                if (backgroundTaskStatusMessageTranslator != null) {
                    backgroundTaskStatusMessageListener = new BackgroundTaskStatusMessageListener(backgroundTaskId, backgroundTaskStatusMessageTranslator);
                    MessageBusUtil.registerMessageListener((String)"liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
                }
                backgroundTask = BackgroundTaskLocalServiceUtil.fetchBackgroundTask((long)backgroundTask.getBackgroundTaskId());
                BackgroundTaskResult backgroundTaskResult = backgroundTaskExecutor.execute(backgroundTask);
                status = backgroundTaskResult.getStatus();
                statusMessage = backgroundTaskResult.getStatusMessage();
                BackgroundTaskLocalServiceUtil.amendBackgroundTask((long)backgroundTaskId, null, (int)status, (String)statusMessage, (ServiceContext)serviceContext);
            }
            catch (DuplicateLockException e) {
                status = 4;
                break block15;
            }
            catch (Exception e2) {
                status = 2;
                if (backgroundTaskExecutor != null) {
                    statusMessage = backgroundTaskExecutor.handleException(backgroundTask, e2);
                }
                if (_log.isInfoEnabled()) {
                    statusMessage = statusMessage != null ? statusMessage.concat(StackTraceUtil.getStackTrace((Throwable)e2)) : StackTraceUtil.getStackTrace((Throwable)e2);
                }
                _log.error((Object)"Unable to execute background task", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                BackgroundTaskLocalServiceUtil.amendBackgroundTask((long)backgroundTaskId, null, (int)status, (String)statusMessage, (ServiceContext)serviceContext);
                BackgroundTaskStatusRegistryUtil.unregisterBackgroundTaskStatus((long)backgroundTaskId);
                if (backgroundTaskStatusMessageListener != null) {
                    MessageBusUtil.unregisterMessageListener((String)"liferay/background_task_status", backgroundTaskStatusMessageListener);
                }
                Message responseMessage = new Message();
                responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                responseMessage.put("name", (Object)backgroundTask.getName());
                responseMessage.put("status", (Object)status);
                responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                MessageBusUtil.sendMessage((String)"liferay/background_task_status", (Message)responseMessage);
                break block15;
            }
            finally {
                BackgroundTaskLocalServiceUtil.amendBackgroundTask((long)backgroundTaskId, null, (int)status, statusMessage, (ServiceContext)serviceContext);
                BackgroundTaskStatusRegistryUtil.unregisterBackgroundTaskStatus((long)backgroundTaskId);
                if (backgroundTaskStatusMessageListener != null) {
                    MessageBusUtil.unregisterMessageListener((String)"liferay/background_task_status", backgroundTaskStatusMessageListener);
                }
                Message responseMessage = new Message();
                responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                responseMessage.put("name", (Object)backgroundTask.getName());
                responseMessage.put("status", (Object)status);
                responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                MessageBusUtil.sendMessage((String)"liferay/background_task_status", (Message)responseMessage);
            }
            BackgroundTaskStatusRegistryUtil.unregisterBackgroundTaskStatus((long)backgroundTaskId);
            if (backgroundTaskStatusMessageListener != null) {
                MessageBusUtil.unregisterMessageListener((String)"liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
            }
            Message responseMessage = new Message();
            responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
            responseMessage.put("name", (Object)backgroundTask.getName());
            responseMessage.put("status", (Object)status);
            responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
            MessageBusUtil.sendMessage((String)"liferay/background_task_status", (Message)responseMessage);
        }
    }

    protected BackgroundTaskExecutor wrapBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, ClassLoader classLoader) {
        if (classLoader != ClassLoaderUtil.getPortalClassLoader()) {
            backgroundTaskExecutor = new ClassLoaderAwareBackgroundTaskExecutor(backgroundTaskExecutor, classLoader);
        }
        if (backgroundTaskExecutor.isSerial()) {
            backgroundTaskExecutor = new SerialBackgroundTaskExecutor(backgroundTaskExecutor);
        }
        return backgroundTaskExecutor;
    }
}

