/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BackgroundTaskStatusRegistryImpl
implements BackgroundTaskStatusRegistry {
    private Map<Long, BackgroundTaskStatus> _backgroundTaskStatuses = new HashMap<Long, BackgroundTaskStatus>();
    private ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskStatus getBackgroundTaskStatus(long backgroundTaskId) {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatuses.get(backgroundTaskId);
            return backgroundTaskStatus;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskStatus registerBackgroundTaskStatus(long backgroundTaskId) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatuses.get(backgroundTaskId);
            if (backgroundTaskStatus == null) {
                backgroundTaskStatus = new BackgroundTaskStatus();
                this._backgroundTaskStatuses.put(backgroundTaskId, backgroundTaskStatus);
            }
            BackgroundTaskStatus backgroundTaskStatus2 = backgroundTaskStatus;
            return backgroundTaskStatus2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskStatus unregisterBackgroundTaskStatus(long backgroundTaskId) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            BackgroundTaskStatus backgroundTaskStatus;
            BackgroundTaskStatus backgroundTaskStatus2 = backgroundTaskStatus = this._backgroundTaskStatuses.remove(backgroundTaskId);
            return backgroundTaskStatus2;
        }
        finally {
            lock.unlock();
        }
    }
}

