/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asset;

import com.liferay.portal.asset.LayoutRevisionAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.User;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;

public class LayoutRevisionAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "layout_revision";

    public LayoutRevisionAssetRendererFactory() {
        this.setCategorizable(false);
        this.setSelectable(false);
    }

    public AssetEntry getAssetEntry(long assetEntryId) throws PortalException {
        return this.getAssetEntry(this.getClassName(), assetEntryId);
    }

    public AssetEntry getAssetEntry(String className, long classPK) throws PortalException {
        LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)classPK);
        LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)layoutRevision.getLayoutSetBranchId());
        User user = UserLocalServiceUtil.getUserById((long)layoutRevision.getUserId());
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.createAssetEntry((long)classPK);
        assetEntry.setGroupId(layoutRevision.getGroupId());
        assetEntry.setCompanyId(user.getCompanyId());
        assetEntry.setUserId(user.getUserId());
        assetEntry.setUserName(user.getFullName());
        assetEntry.setCreateDate(layoutRevision.getCreateDate());
        assetEntry.setClassNameId(PortalUtil.getClassNameId((String)LayoutRevision.class.getName()));
        assetEntry.setClassPK(layoutRevision.getLayoutRevisionId());
        StringBundler sb = new StringBundler(4);
        sb.append(layoutRevision.getHTMLTitle(LocaleUtil.getSiteDefault()));
        sb.append(" [");
        sb.append(layoutSetBranch.getName());
        sb.append("]");
        assetEntry.setTitle(sb.toString());
        return assetEntry;
    }

    public AssetRenderer getAssetRenderer(long layoutRevisionId, int type) throws PortalException {
        LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
        LayoutRevisionAssetRenderer layoutRevisionAssetRenderer = new LayoutRevisionAssetRenderer(layoutRevision);
        layoutRevisionAssetRenderer.setAssetRendererType(type);
        return layoutRevisionAssetRenderer;
    }

    public String getClassName() {
        return LayoutRevision.class.getName();
    }

    public String getIconCssClass() {
        return "icon-file";
    }

    public String getType() {
        return TYPE;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/pages.png";
    }
}

