/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asset;

import com.liferay.portal.asset.LayoutAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.User;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;

public class LayoutAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "layout";
    private static final boolean _SELECTABLE = false;

    public AssetEntry getAssetEntry(long assetEntryId) throws PortalException {
        return this.getAssetEntry(this.getClassName(), assetEntryId);
    }

    public AssetEntry getAssetEntry(String className, long classPK) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)classPK);
        User user = UserLocalServiceUtil.getUserById((long)layout.getUserId());
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.createAssetEntry((long)classPK);
        assetEntry.setGroupId(layout.getGroupId());
        assetEntry.setCompanyId(user.getCompanyId());
        assetEntry.setUserId(user.getUserId());
        assetEntry.setUserName(user.getFullName());
        assetEntry.setCreateDate(layout.getCreateDate());
        assetEntry.setClassNameId(PortalUtil.getClassNameId((String)Layout.class.getName()));
        assetEntry.setClassPK(layout.getLayoutId());
        assetEntry.setTitle(layout.getHTMLTitle(LocaleUtil.getSiteDefault()));
        return assetEntry;
    }

    public AssetRenderer getAssetRenderer(long plid, int type) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        LayoutAssetRenderer layoutAssetRenderer = new LayoutAssetRenderer(layout);
        layoutAssetRenderer.setAssetRendererType(type);
        return layoutAssetRenderer;
    }

    public String getClassName() {
        return Layout.class.getName();
    }

    public String getType() {
        return TYPE;
    }

    public boolean isSelectable() {
        return false;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/pages.png";
    }
}

