/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asset;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class LayoutAssetRenderer
extends BaseAssetRenderer {
    private Layout _layout;

    public LayoutAssetRenderer(Layout layout) {
        this._layout = layout;
    }

    public String getClassName() {
        return Layout.class.getName();
    }

    public long getClassPK() {
        return this._layout.getLayoutId();
    }

    public long getGroupId() {
        return this._layout.getGroupId();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        Locale locale = this.getLocale(portletRequest);
        StringBundler sb = new StringBundler(4);
        sb.append("<strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)"page"));
        sb.append(":</strong> ");
        sb.append(this._layout.getHTMLTitle(locale));
        return sb.toString();
    }

    public String getTitle(Locale locale) {
        return this._layout.getHTMLTitle(locale);
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = LayoutLocalServiceUtil.getLayout((long)this._layout.getPlid());
            return PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        catch (Exception e) {
            return "";
        }
    }

    public long getUserId() {
        return this._layout.getUserId();
    }

    public String getUserName() {
        return this._layout.getUserName();
    }

    public String getUuid() {
        return null;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("full_content")) {
            renderRequest.setAttribute("LAYOUT", (Object)this._layout);
            return "/html/portlet/layouts_admin/asset/" + template + ".jsp";
        }
        return null;
    }
}

