/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.aspectj;

import com.liferay.portal.aspectj.URLWeavingAdapter;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.ProtectionDomain;
import java.util.Arrays;
import org.aspectj.bridge.AbortException;

public class WeavingClassLoader
extends URLClassLoader {
    private static Log _log = LogFactoryUtil.getLog(WeavingClassLoader.class);
    private File _dumpDir;
    private URLWeavingAdapter _urlWeavingAdapter;

    public WeavingClassLoader(URL[] urls, Class<?>[] aspectClasses, File dumpDir) {
        super(urls, (ClassLoader)null);
        this._dumpDir = dumpDir;
        this._urlWeavingAdapter = new URLWeavingAdapter(urls, aspectClasses);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String resourcePath = name.replace('.', '/') + ".class";
        InputStream inputStream = this.getResourceAsStream(resourcePath);
        byte[] data = null;
        try {
            byte[] oldData;
            block12: {
                if (inputStream == null) {
                    data = this._urlWeavingAdapter.removeGeneratedClassDate(name);
                } else {
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
                    data = unsyncByteArrayOutputStream.toByteArray();
                }
                if (data == null) {
                    throw new ClassNotFoundException(name);
                }
                oldData = data;
                try {
                    data = this._urlWeavingAdapter.weaveClass(name, data, false);
                }
                catch (AbortException ae) {
                    if (!_log.isWarnEnabled()) break block12;
                    _log.warn((Object)("Abort weaving class " + name), (Throwable)ae);
                }
            }
            if (Arrays.equals(oldData, data)) {
                return this._generateClass(name, data);
            }
            if (this._dumpDir != null) {
                File dumpFile = new File(this._dumpDir, resourcePath);
                File dumpDir = dumpFile.getParentFile();
                dumpDir.mkdirs();
                Files.write(dumpFile.toPath(), data, new OpenOption[0]);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Woven class " + name + " result in " + dumpFile.getCanonicalPath()));
                }
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)("Woven class " + name));
            }
            return this._generateClass(name, data);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(name, ioe);
        }
    }

    private Class<?> _generateClass(String name, byte[] data) {
        Package pkg;
        Class<?> clazz = this.defineClass(name, data, 0, data.length, (ProtectionDomain)null);
        String packageName = null;
        int index = name.lastIndexOf(46);
        if (index != -1) {
            packageName = name.substring(0, index);
        }
        if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        return clazz;
    }
}

