/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.login.util.LoginUtil;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LoginAction
extends Action {
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portalURLSecure;
        String portalURL;
        HttpSession session;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            response.sendRedirect(themeDisplay.getPathMain() + PropsValues.AUTH_LOGIN_DISABLED_PATH);
            return null;
        }
        if (PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !request.isSecure()) {
            StringBundler sb = new StringBundler(4);
            sb.append(PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)true));
            sb.append(request.getRequestURI());
            sb.append("?");
            sb.append(request.getQueryString());
            response.sendRedirect(sb.toString());
            return null;
        }
        String login = ParamUtil.getString((HttpServletRequest)request, (String)"login");
        String password = request.getParameter("password");
        boolean rememberMe = ParamUtil.getBoolean((HttpServletRequest)request, (String)"rememberMe");
        String authType = ParamUtil.getString((HttpServletRequest)request, (String)"authType");
        if (Validator.isNotNull((String)login) && Validator.isNotNull((String)password)) {
            LoginUtil.login(request, response, login, password, rememberMe, authType);
        }
        if ((session = request.getSession()).getAttribute("j_username") != null && session.getAttribute("j_password") != null) {
            String portalURL2;
            if (PropsValues.PORTAL_JAAS_ENABLE) {
                return actionMapping.findForward("/portal/touch_protected.jsp");
            }
            String redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
            if (Validator.isNull((String)(redirect = PortalUtil.escapeRedirect((String)redirect)))) {
                redirect = themeDisplay.getPathMain();
            }
            if (redirect.charAt(0) == '/' && Validator.isNotNull((String)(portalURL2 = PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)request.isSecure())))) {
                redirect = portalURL2.concat(redirect);
            }
            response.sendRedirect(redirect);
            return null;
        }
        String redirect = PortalUtil.getSiteLoginURL((ThemeDisplay)themeDisplay);
        if (Validator.isNull((String)redirect)) {
            redirect = PropsValues.AUTH_LOGIN_URL;
        }
        if (Validator.isNull((String)redirect)) {
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"58", (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
            portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
            portletURL.setParameter("struts_action", "/login/login");
            portletURL.setPortletMode(PortletMode.VIEW);
            portletURL.setWindowState(this.getWindowState(request));
            redirect = portletURL.toString();
        }
        if (PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !(portalURL = PortalUtil.getPortalURL((HttpServletRequest)request)).equals(portalURLSecure = PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)true))) {
            redirect = StringUtil.replaceFirst((String)redirect, (String)portalURL, (String)portalURLSecure);
        }
        String loginRedirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
        if (Validator.isNotNull((String)(loginRedirect = PortalUtil.escapeRedirect((String)loginRedirect)))) {
            if (SSOUtil.isRedirectRequired(themeDisplay.getCompanyId())) {
                redirect = loginRedirect;
            } else {
                String loginPortletNamespace = PortalUtil.getPortletNamespace((String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                String loginRedirectParameter = loginPortletNamespace + "redirect";
                redirect = HttpUtil.setParameter((String)redirect, (String)"p_p_id", (String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                redirect = HttpUtil.setParameter((String)redirect, (String)"p_p_lifecycle", (String)"0");
                redirect = HttpUtil.setParameter((String)redirect, (String)loginRedirectParameter, (String)loginRedirect);
            }
        }
        response.sendRedirect(redirect);
        return null;
    }

    protected WindowState getWindowState(HttpServletRequest request) {
        WindowState windowState = WindowState.MAXIMIZED;
        String windowStateString = ParamUtil.getString((HttpServletRequest)request, (String)"windowState");
        if (Validator.isNotNull((String)windowStateString)) {
            windowState = WindowStateFactory.getWindowState((String)windowStateString);
        }
        return windowState;
    }
}

