/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.util;

import com.liferay.mail.model.Filter;
import com.liferay.mail.service.CyrusServiceUtil;
import com.liferay.mail.util.Hook;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.util.List;

public class CyrusHook
implements Hook {
    private static Log _log = LogFactoryUtil.getLog(CyrusHook.class);

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
        try {
            if (emailAddresses != null) {
                String home = PropsUtil.get("mail.hook.cyrus.home");
                File file = new File(home + "/" + userId + ".procmail.forward");
                if (!filters.isEmpty() || !emailAddresses.isEmpty() || leaveCopy) {
                    StringBundler sb = new StringBundler(5 * filters.size() + 2 * emailAddresses.size() + 4);
                    for (int i = 0; i < filters.size(); ++i) {
                        Filter filter = filters.get(i);
                        sb.append(":0\n* ^(From|Cc|To).*");
                        sb.append(filter.getEmailAddress());
                        sb.append("\n| $DELIVER -e -a $USER -m user.$USER.");
                        sb.append(filter.getFolder());
                        sb.append("\n\n");
                    }
                    if (leaveCopy) {
                        sb.append(":0 c\n");
                        sb.append("| $DELIVER -e -a $USER -m user.$USER\n\n");
                    }
                    if (!emailAddresses.isEmpty()) {
                        sb.append(":0\n");
                        sb.append("!");
                        for (String emailAddress : emailAddresses) {
                            sb.append(" ");
                            sb.append(emailAddress);
                        }
                    }
                    String content = sb.toString();
                    while (content.endsWith("\n")) {
                        content = content.substring(0, content.length() - 1);
                    }
                    FileUtil.write((File)file, (String)content);
                } else {
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        try {
            CyrusServiceUtil.addUser((long)userId, (String)emailAddress, (String)password);
            String addUserCmd = PropsUtil.get("mail.hook.cyrus.add.user");
            addUserCmd = StringUtil.replace((String)addUserCmd, (String)"%1%", (String)String.valueOf(userId));
            NoticeableFuture future = ProcessUtil.execute((OutputProcessor)ProcessUtil.LOGGING_OUTPUT_PROCESSOR, (String[])new String[]{addUserCmd});
            future.get();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
        try {
            String home = PropsUtil.get("mail.hook.cyrus.home");
            new File(home + "/" + userId + ".vacation.cache").delete();
            File vacation = new File(home + "/" + userId + ".vacation");
            if (Validator.isNull((String)vacationMessage)) {
                vacation.delete();
            } else {
                FileUtil.write((File)vacation, (String)(emailAddress + "\n" + vacationMessage));
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void deleteEmailAddress(long companyId, long userId) {
        try {
            CyrusServiceUtil.deleteEmailAddress((long)companyId, (long)userId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void deleteUser(long companyId, long userId) {
        try {
            CyrusServiceUtil.deleteUser((long)userId);
            String deleteUserCmd = PropsUtil.get("mail.hook.cyrus.delete.user");
            deleteUserCmd = StringUtil.replace((String)deleteUserCmd, (String)"%1%", (String)String.valueOf(userId));
            NoticeableFuture future = ProcessUtil.execute((OutputProcessor)ProcessUtil.LOGGING_OUTPUT_PROCESSOR, (String[])new String[]{deleteUserCmd});
            future.get();
            String home = PropsUtil.get("mail.hook.cyrus.home");
            File file = new File(home + "/" + userId + ".procmail.blocked");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(home + "/" + userId + ".procmail.forward")).exists()) {
                file.delete();
            }
            if ((file = new File(home + "/" + userId + ".vacation")).exists()) {
                file.delete();
            }
            if ((file = new File(home + "/" + userId + ".vacation.cache")).exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
        String home = PropsUtil.get("mail.hook.cyrus.home");
        File file = new File(home + "/" + userId + ".procmail.blocked");
        if (ListUtil.isEmpty(blocked)) {
            file.delete();
            return;
        }
        StringBundler sb = new StringBundler(blocked.size() * 9);
        for (int i = 0; i < blocked.size(); ++i) {
            String emailAddress = blocked.get(i);
            sb.append("\n");
            sb.append(":0\n");
            sb.append("* ^From.*");
            sb.append(emailAddress);
            sb.append("\n");
            sb.append("{\n");
            sb.append(":0\n");
            sb.append("/dev/null\n");
            sb.append("}\n");
        }
        try {
            FileUtil.write((File)file, (String)sb.toString());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        try {
            CyrusServiceUtil.updateEmailAddress((long)companyId, (long)userId, (String)emailAddress);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void updatePassword(long companyId, long userId, String password) {
        try {
            CyrusServiceUtil.updatePassword((long)companyId, (long)userId, (String)password);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

