/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.persistence.WikiNodeActionableDynamicQuery;
import java.util.Locale;
import javax.portlet.PortletURL;

public class WikiNodeIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{WikiNode.class.getName()};
    public static final String PORTLET_ID = "36";

    public WikiNodeIndexer() {
        this.setFilterSearch(false);
        this.setPermissionAware(false);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)entryClassPK);
        return WikiNodePermission.contains(permissionChecker, node, "VIEW");
    }

    protected void doDelete(Object obj) throws Exception {
        WikiNode node = (WikiNode)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, node.getNodeId(), node.getName());
        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)node.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        WikiNode node = (WikiNode)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)node);
        document.addUID(PORTLET_ID, node.getNodeId(), node.getName());
        document.addText("description", node.getDescription());
        document.addText("title", node.getName());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) throws Exception {
        return null;
    }

    protected void doReindex(Object obj) throws Exception {
        WikiNode node = (WikiNode)obj;
        Document document = this.getDocument(obj);
        if (!node.isInTrash()) {
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)node.getCompanyId(), (String)document.get("uid"));
            return;
        }
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)node.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)classPK);
        this.doReindex(node);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEntries(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId) throws PortalException, SystemException {
        WikiNodeActionableDynamicQuery actionableDynamicQuery = new WikiNodeActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"status");
                dynamicQuery.add(property.eq((Object)8));
            }

            protected void performAction(Object object) throws PortalException {
                WikiNode node = (WikiNode)object;
                Document document = WikiNodeIndexer.this.getDocument(node);
                this.addDocument(document);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

