/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.persistence.WikiNodeExportActionableDynamicQuery;
import com.liferay.portlet.wiki.service.persistence.WikiPageExportActionableDynamicQuery;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "wiki";

    public WikiPortletDataHandler() {
        this.setDataPortletPreferences(new String[]{"hiddenNodes, visibleNodes"});
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(WikiNode.class), new StagedModelType(WikiPage.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "wiki-pages", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "referenced-content")}, WikiPage.class.getName())});
        this.setImportControls(this.getExportControls());
    }

    public PortletPreferences importData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws PortletDataException {
        WikiCacheThreadLocal.setClearCache(false);
        try {
            PortletPreferences portletPreferences2 = super.importData(portletDataContext, portletId, portletPreferences, data);
            return portletPreferences2;
        }
        finally {
            WikiCacheThreadLocal.setClearCache(true);
        }
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(WikiPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        WikiNodeLocalServiceUtil.deleteNodes((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages")) {
            return this.getExportDataRootElementString(rootElement);
        }
        portletDataContext.addPortletPermissions("com.liferay.portlet.wiki");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        WikiNodeExportActionableDynamicQuery nodeActionableDynamicQuery = new WikiNodeExportActionableDynamicQuery(portletDataContext);
        nodeActionableDynamicQuery.performActions();
        WikiPageExportActionableDynamicQuery pageActionableDynamicQuery = new WikiPageExportActionableDynamicQuery(portletDataContext);
        pageActionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages")) {
            return null;
        }
        portletDataContext.importPortletPermissions("com.liferay.portlet.wiki");
        Element nodesElement = portletDataContext.getImportDataGroupElement(WikiNode.class);
        List nodeElements = nodesElement.elements();
        for (Element nodeElement : nodeElements) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (Element)nodeElement);
        }
        Element pagesElement = portletDataContext.getImportDataGroupElement(WikiPage.class);
        List pageElements = pagesElement.elements();
        for (Element pageElement : pageElements) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (Element)pageElement);
        }
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        Iterator iterator = nodeIds.values().iterator();
        while (iterator.hasNext()) {
            long nodeId = (Long)iterator.next();
            WikiCacheUtil.clearCache(nodeId);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        WikiNodeExportActionableDynamicQuery nodeActionableDynamicQuery = new WikiNodeExportActionableDynamicQuery(portletDataContext);
        nodeActionableDynamicQuery.performCount();
        WikiPageExportActionableDynamicQuery pageExportActionableDynamicQuery = new WikiPageExportActionableDynamicQuery(portletDataContext);
        pageExportActionableDynamicQuery.performCount();
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        String hiddenNodeNames = portletPreferences.getValue("hiddenNodes", null);
        String[] stringArray = StringUtil.split((String)hiddenNodeNames);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String hiddenNodeName = stringArray[n2];
            WikiNode wikiNode = WikiNodeLocalServiceUtil.getNode((long)portletDataContext.getScopeGroupId(), (String)hiddenNodeName);
            portletDataContext.addReferenceElement((ClassedModel)portlet, portletDataContext.getExportDataRootElement(), (ClassedModel)wikiNode, WikiNode.class, "dependency", !portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages"));
            ++n2;
        }
        String visibleNodeNames = portletPreferences.getValue("visibleNodes", null);
        String[] stringArray2 = StringUtil.split((String)visibleNodeNames);
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String visibleNodeName = stringArray2[n];
            WikiNode wikiNode = WikiNodeLocalServiceUtil.getNode((long)portletDataContext.getScopeGroupId(), (String)visibleNodeName);
            portletDataContext.addReferenceElement((ClassedModel)portlet, portletDataContext.getExportDataRootElement(), (ClassedModel)wikiNode, WikiNode.class, "dependency", !portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages"));
            ++n;
        }
        return portletPreferences;
    }
}

