/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class WikiPageStagedModelDataHandler
extends BaseStagedModelDataHandler<WikiPage> {
    public static final String[] CLASS_NAMES = new String[]{WikiPage.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        WikiPage wikiPage = WikiPageLocalServiceUtil.fetchWikiPageByUuidAndGroupId((String)uuid, (long)groupId);
        if (wikiPage != null) {
            WikiPageLocalServiceUtil.deletePage((WikiPage)wikiPage);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        Element pageElement = portletDataContext.getExportDataElement((ClassedModel)page);
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)page, (StagedModel)page.getNode(), (String)"parent");
        String content = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)page, (Element)pageElement, (String)page.getContent(), (boolean)portletDataContext.getBooleanParameter("wiki", "referenced-content"));
        page.setContent(content);
        if (page.isHead()) {
            for (FileEntry fileEntry : page.getAttachmentsFileEntries()) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)page, WikiPage.class, (StagedModel)fileEntry, FileEntry.class, (String)"weak");
            }
        }
        portletDataContext.addClassedModel(pageElement, ExportImportPathUtil.getModelPath((StagedModel)page), (ClassedModel)page);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        long userId = portletDataContext.getUserId(page.getUserUuid());
        String nodePath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)WikiNode.class.getName(), (long)page.getNodeId());
        WikiNode node = (WikiNode)portletDataContext.getZipEntryAsObject(nodePath);
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)node);
        Element pageElement = portletDataContext.getImportDataStagedModelElement((StagedModel)page);
        String content = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (Element)pageElement, (String)page.getContent(), (boolean)portletDataContext.getBooleanParameter("wiki", "referenced-content"));
        page.setContent(content);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)page);
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        long nodeId = MapUtil.getLong((Map)nodeIds, (long)page.getNodeId(), (long)page.getNodeId());
        WikiPage importedPage = null;
        WikiPage existingPage = WikiPageLocalServiceUtil.fetchWikiPageByUuidAndGroupId((String)page.getUuid(), (long)portletDataContext.getScopeGroupId());
        if (existingPage == null) {
            try {
                existingPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)page.getTitle());
            }
            catch (NoSuchPageException noSuchPageException) {}
        }
        if (existingPage == null) {
            serviceContext.setUuid(page.getUuid());
            importedPage = WikiPageLocalServiceUtil.addPage((long)userId, (long)nodeId, (String)page.getTitle(), (double)page.getVersion(), (String)page.getContent(), (String)page.getSummary(), (boolean)page.isMinorEdit(), (String)page.getFormat(), (boolean)page.getHead(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
        } else {
            importedPage = WikiPageLocalServiceUtil.updatePage((long)userId, (long)nodeId, (String)existingPage.getTitle(), (double)0.0, (String)page.getContent(), (String)page.getSummary(), (boolean)page.isMinorEdit(), (String)page.getFormat(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
        }
        if (page.isHead()) {
            List attachmentElements = portletDataContext.getReferenceDataElements(pageElement, FileEntry.class, "weak");
            for (Element attachmentElement : attachmentElements) {
                String path = attachmentElement.attributeValue("path");
                String binPath = attachmentElement.attributeValue("bin-path");
                FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
                InputStream inputStream = null;
                String mimeType = null;
                try {
                    inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
                    mimeType = MimeTypesUtil.getContentType((InputStream)inputStream, (String)fileEntry.getTitle());
                }
                finally {
                    StreamUtil.cleanUp((InputStream)inputStream);
                }
                try {
                    inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
                    WikiPageLocalServiceUtil.addPageAttachment((long)userId, (long)importedPage.getNodeId(), (String)importedPage.getTitle(), (String)fileEntry.getTitle(), (InputStream)inputStream, (String)mimeType);
                }
                finally {
                    StreamUtil.cleanUp((InputStream)inputStream);
                }
            }
        }
        portletDataContext.importClassedModel((ClassedModel)page, (ClassedModel)importedPage);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        long userId = portletDataContext.getUserId(page.getUserUuid());
        WikiPage existingPage = WikiPageLocalServiceUtil.fetchWikiPageByUuidAndGroupId((String)page.getUuid(), (long)portletDataContext.getScopeGroupId());
        if (existingPage == null || !existingPage.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingPage.getTrashHandler();
        if (trashHandler.isRestorable(existingPage.getResourcePrimKey())) {
            trashHandler.restoreTrashEntry(userId, existingPage.getResourcePrimKey());
        }
    }
}

