/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.importers.mediawiki;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.ProgressTrackerThreadLocal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagPropertyLocalServiceUtil;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.wiki.ImportFilesException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.importers.WikiImporter;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.translators.MediaWikiToCreoleTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaWikiImporter
implements WikiImporter {
    public static final String SHARED_IMAGES_CONTENT = "See attachments";
    public static final String SHARED_IMAGES_TITLE = "SharedImages";
    private static final String _WORK_IN_PROGRESS = "{{Work in progress}}";
    private static final String _WORK_IN_PROGRESS_TAG = "work in progress";
    private static Log _log = LogFactoryUtil.getLog(MediaWikiImporter.class);
    private static Pattern _categoriesPattern = Pattern.compile("\\[\\[[Cc]ategory:([^\\]]*)\\]\\][\\n]*");
    private static Pattern _parentPattern = Pattern.compile("\\{{2}OtherTopics\\|([^\\}]*)\\}{2}");
    private static Pattern _redirectPattern = Pattern.compile("#REDIRECT \\[\\[([^\\]]*)\\]\\]");
    private static Set<String> _specialMediaWikiDirs = SetUtil.fromArray((Object[])new String[]{"archive", "temp", "thumb"});
    private MediaWikiToCreoleTranslator _translator = new MediaWikiToCreoleTranslator();

    @Override
    public void importPages(long userId, WikiNode node, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException {
        if (inputStreams.length < 1 || inputStreams[0] == null) {
            throw new PortalException("The pages file is mandatory");
        }
        InputStream pagesInputStream = inputStreams[0];
        InputStream usersInputStream = inputStreams[1];
        InputStream imagesInputStream = inputStreams[2];
        try {
            Document document = SAXReaderUtil.read((InputStream)pagesInputStream);
            Map<String, String> usersMap = this.readUsersFile(usersInputStream);
            Element rootElement = document.getRootElement();
            List<String> specialNamespaces = this.readSpecialNamespaces(rootElement);
            this.processSpecialPages(userId, node, rootElement, specialNamespaces);
            this.processRegularPages(userId, node, rootElement, specialNamespaces, usersMap, imagesInputStream, options);
            this.processImages(userId, node, imagesInputStream);
            this.moveFrontPage(userId, node, options);
        }
        catch (DocumentException documentException) {
            throw new ImportFilesException("Invalid XML file provided");
        }
        catch (IOException iOException) {
            throw new ImportFilesException("Error reading the files provided");
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e2) {
            throw new PortalException((Throwable)e2);
        }
    }

    protected long getUserId(long userId, WikiNode node, String author, Map<String, String> usersMap) throws SystemException {
        User user = null;
        String emailAddress = usersMap.get(author);
        user = Validator.isNotNull((String)emailAddress) ? UserLocalServiceUtil.fetchUserByEmailAddress((long)node.getCompanyId(), (String)emailAddress) : UserLocalServiceUtil.fetchUserByScreenName((long)node.getCompanyId(), (String)StringUtil.toLowerCase((String)author));
        if (user != null) {
            return user.getUserId();
        }
        return userId;
    }

    protected void importPage(long userId, String author, WikiNode node, String title, String content, String summary, Map<String, String> usersMap, boolean strictImportMode) throws PortalException {
        try {
            long authorUserId = this.getUserId(userId, node, author, usersMap);
            String parentTitle = this.readParentTitle(content);
            String redirectTitle = this.readRedirectTitle(content);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setAssetTagNames(this.readAssetTagNames(userId, node, content));
            if (Validator.isNull((String)redirectTitle)) {
                this._translator.setStrictImportMode(strictImportMode);
                content = this._translator.translate(content);
            } else {
                content = "[[" + redirectTitle + "]]";
            }
            WikiPage page = null;
            try {
                page = WikiPageLocalServiceUtil.getPage((long)node.getNodeId(), (String)title);
            }
            catch (NoSuchPageException noSuchPageException) {
                page = WikiPageLocalServiceUtil.addPage((long)authorUserId, (long)node.getNodeId(), (String)title, (String)"New", null, (boolean)true, (ServiceContext)serviceContext);
            }
            WikiPageLocalServiceUtil.updatePage((long)authorUserId, (long)node.getNodeId(), (String)title, (double)page.getVersion(), (String)content, (String)summary, (boolean)true, (String)"creole", (String)parentTitle, (String)redirectTitle, (ServiceContext)serviceContext);
        }
        catch (Exception e2) {
            throw new PortalException("Error importing page " + title, (Throwable)e2);
        }
    }

    protected boolean isSpecialMediaWikiPage(String title, List<String> specialNamespaces) {
        for (String namespace : specialNamespaces) {
            if (!title.startsWith(String.valueOf(namespace) + ":")) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidImage(String[] paths, InputStream inputStream) {
        if (_specialMediaWikiDirs.contains(paths[0])) {
            return false;
        }
        if (paths.length > 1 && _specialMediaWikiDirs.contains(paths[1])) {
            return false;
        }
        String fileName = paths[paths.length - 1];
        try {
            DLStoreUtil.validate((String)fileName, (boolean)true, (InputStream)inputStream);
        }
        catch (PortalException portalException) {
            return false;
        }
        catch (SystemException systemException) {
            return false;
        }
        return true;
    }

    protected void moveFrontPage(long userId, WikiNode node, Map<String, String[]> options) {
        block4: {
            String frontPageTitle = MapUtil.getString(options, (String)"OPTIONS_FRONT_PAGE");
            if (Validator.isNotNull((String)frontPageTitle)) {
                frontPageTitle = this.normalizeTitle(frontPageTitle);
                try {
                    if (WikiPageLocalServiceUtil.getPagesCount((long)node.getNodeId(), (String)frontPageTitle, (boolean)true) > 0) {
                        ServiceContext serviceContext = new ServiceContext();
                        serviceContext.setAddGroupPermissions(true);
                        serviceContext.setAddGuestPermissions(true);
                        WikiPageLocalServiceUtil.movePage((long)userId, (long)node.getNodeId(), (String)frontPageTitle, (String)WikiPageConstants.FRONT_PAGE, (boolean)false, (ServiceContext)serviceContext);
                    }
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block4;
                    StringBundler sb = new StringBundler(4);
                    sb.append("Could not move ");
                    sb.append(WikiPageConstants.FRONT_PAGE);
                    sb.append(" to the title provided: ");
                    sb.append(frontPageTitle);
                    _log.warn((Object)sb.toString(), (Throwable)e2);
                }
            }
        }
    }

    protected String normalize(String categoryName, int length) {
        categoryName = AssetUtil.toWord(categoryName.trim());
        return StringUtil.shorten((String)categoryName, (int)length);
    }

    protected String normalizeDescription(String description) {
        description = description.replaceAll(_categoriesPattern.pattern(), "");
        return this.normalize(description, 300);
    }

    protected String normalizeTitle(String title) {
        title = title.replaceAll(PropsValues.WIKI_PAGE_TITLES_REMOVE_REGEXP, "");
        return StringUtil.shorten((String)title, (int)75);
    }

    /*
     * Unable to fully structure code
     */
    protected void processImages(long userId, WikiNode node, InputStream imagesInputStream) throws Exception {
        if (imagesInputStream == null) {
            return;
        }
        progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        count = 0;
        zipReader = ZipReaderFactoryUtil.getZipReader((InputStream)imagesInputStream);
        entries = zipReader.getEntries();
        total = entries.size();
        if (total > 0) {
            try {
                WikiPageLocalServiceUtil.getPage((long)node.getNodeId(), (String)"SharedImages");
            }
            catch (NoSuchPageException v0) {
                serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                WikiPageLocalServiceUtil.addPage((long)userId, (long)node.getNodeId(), (String)"SharedImages", (String)"See attachments", null, (boolean)true, (ServiceContext)serviceContext);
            }
        }
        inputStreamOVPs = new ArrayList<ObjectValuePair>();
        try {
            percentage = 50;
            i = 0;
            while (i < entries.size()) {
                key = entry = (String)entries.get(i);
                inputStream = zipReader.getEntryAsInputStream(entry);
                paths = StringUtil.split((String)key, (char)'/');
                if (!this.isValidImage(paths, inputStream)) {
                    if (MediaWikiImporter._log.isInfoEnabled()) {
                        MediaWikiImporter._log.info((Object)("Ignoring " + key));
                    }
                } else {
                    fileName = StringUtil.toLowerCase((String)paths[paths.length - 1]);
                    inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                    inputStreamOVPs.add(inputStreamOVP);
                    ++count;
                    if (i % 5 == 0) {
                        WikiPageLocalServiceUtil.addPageAttachments((long)userId, (long)node.getNodeId(), (String)"SharedImages", inputStreamOVPs);
                        inputStreamOVPs.clear();
                        percentage = Math.min(50 + i * 50 / total, 99);
                        progressTracker.setPercent(percentage);
                    }
                }
                ++i;
            }
            if (!inputStreamOVPs.isEmpty()) {
                WikiPageLocalServiceUtil.addPageAttachments((long)userId, (long)node.getNodeId(), (String)"SharedImages", inputStreamOVPs);
            }
        }
        finally {
            var21_20 = inputStreamOVPs.iterator();
            if (true) ** GOTO lbl56
        }
        {
        }
        do {
            inputStreamOVP = (ObjectValuePair)var21_20.next();
            inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((InputStream)inputStream);
lbl56:
            // 2 sources

        } while (var21_20.hasNext());
        zipReader.close();
        if (MediaWikiImporter._log.isInfoEnabled()) {
            MediaWikiImporter._log.info((Object)("Imported " + count + " images into " + node.getName()));
        }
    }

    protected void processRegularPages(long userId, WikiNode node, Element rootElement, List<String> specialNamespaces, Map<String, String> usersMap, InputStream imagesInputStream, Map<String, String[]> options) {
        boolean importLatestVersion = MapUtil.getBoolean(options, (String)"OPTIONS_IMPORT_LATEST_VERSION");
        boolean strictImportMode = MapUtil.getBoolean(options, (String)"OPTIONS_STRICT_IMPORT_MODE");
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        int count = 0;
        int percentage = 10;
        int maxPercentage = 50;
        if (imagesInputStream == null) {
            maxPercentage = 99;
        }
        List pageElements = rootElement.elements("page");
        int i2 = 0;
        while (i2 < pageElements.size()) {
            Element pageElement = (Element)pageElements.get(i2);
            String title = pageElement.elementText("title");
            title = this.normalizeTitle(title);
            percentage = Math.min(10 + i2 * (maxPercentage - percentage) / pageElements.size(), maxPercentage);
            progressTracker.setPercent(percentage);
            if (!this.isSpecialMediaWikiPage(title, specialNamespaces)) {
                ArrayList<Element> revisionElements = pageElement.elements("revision");
                if (importLatestVersion) {
                    Element lastRevisionElement = (Element)revisionElements.get(revisionElements.size() - 1);
                    revisionElements = new ArrayList<Element>();
                    revisionElements.add(lastRevisionElement);
                }
                for (Element revisionElement : revisionElements) {
                    Element contributorElement = revisionElement.element("contributor");
                    String author = contributorElement.elementText("username");
                    String content = revisionElement.elementText("text");
                    String summary = revisionElement.elementText("comment");
                    try {
                        this.importPage(userId, author, node, title, content, summary, usersMap, strictImportMode);
                    }
                    catch (Exception e2) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("Page with title " + title + " could not be imported"), (Throwable)e2);
                    }
                }
                ++count;
            }
            ++i2;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Imported " + count + " pages into " + node.getName()));
        }
    }

    protected void processSpecialPages(long userId, WikiNode node, Element rootElement, List<String> specialNamespaces) throws PortalException {
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        List pageElements = rootElement.elements("page");
        int i2 = 0;
        while (i2 < pageElements.size()) {
            Element pageElement = (Element)pageElements.get(i2);
            String title = pageElement.elementText("title");
            if (!title.startsWith("Category:")) {
                if (this.isSpecialMediaWikiPage(title, specialNamespaces)) {
                    rootElement.remove(pageElement);
                }
            } else {
                String categoryName = title.substring("Category:".length());
                categoryName = this.normalize(categoryName, 75);
                Element revisionElement = pageElement.element("revision");
                String description = revisionElement.elementText("text");
                description = this.normalizeDescription(description);
                try {
                    AssetTag assetTag = null;
                    try {
                        assetTag = AssetTagLocalServiceUtil.getTag((long)node.getCompanyId(), (String)categoryName);
                    }
                    catch (NoSuchTagException noSuchTagException) {
                        ServiceContext serviceContext = new ServiceContext();
                        serviceContext.setAddGroupPermissions(true);
                        serviceContext.setAddGuestPermissions(true);
                        serviceContext.setScopeGroupId(node.getGroupId());
                        assetTag = AssetTagLocalServiceUtil.addTag((long)userId, (String)categoryName, null, (ServiceContext)serviceContext);
                    }
                    if (Validator.isNotNull((String)description)) {
                        AssetTagPropertyLocalServiceUtil.addTagProperty((long)userId, (long)assetTag.getTagId(), (String)"description", (String)description);
                    }
                }
                catch (SystemException se) {
                    _log.error((Object)se, (Throwable)se);
                }
                if (i2 % 5 == 0) {
                    progressTracker.setPercent(i2 * 10 / pageElements.size());
                }
            }
            ++i2;
        }
    }

    protected String[] readAssetTagNames(long userId, WikiNode node, String content) throws PortalException, SystemException {
        Matcher matcher = _categoriesPattern.matcher(content);
        ArrayList<String> assetTagNames = new ArrayList<String>();
        while (matcher.find()) {
            String categoryName = matcher.group(1);
            categoryName = this.normalize(categoryName, 75);
            AssetTag assetTag = null;
            try {
                assetTag = AssetTagLocalServiceUtil.getTag((long)node.getGroupId(), (String)categoryName);
            }
            catch (NoSuchTagException noSuchTagException) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(node.getGroupId());
                assetTag = AssetTagLocalServiceUtil.addTag((long)userId, (String)categoryName, null, (ServiceContext)serviceContext);
            }
            assetTagNames.add(assetTag.getName());
        }
        if (content.contains(_WORK_IN_PROGRESS)) {
            assetTagNames.add(_WORK_IN_PROGRESS_TAG);
        }
        return assetTagNames.toArray(new String[assetTagNames.size()]);
    }

    protected String readParentTitle(String content) {
        Matcher matcher = _parentPattern.matcher(content);
        String redirectTitle = "";
        if (matcher.find()) {
            redirectTitle = matcher.group(1);
            redirectTitle = this.normalizeTitle(redirectTitle);
            redirectTitle = String.valueOf(redirectTitle) + " (disambiguation)";
        }
        return redirectTitle;
    }

    protected String readRedirectTitle(String content) {
        Matcher matcher = _redirectPattern.matcher(content);
        String redirectTitle = "";
        if (matcher.find()) {
            redirectTitle = matcher.group(1);
            redirectTitle = this.normalizeTitle(redirectTitle);
        }
        return redirectTitle;
    }

    protected List<String> readSpecialNamespaces(Element root) throws ImportFilesException {
        ArrayList<String> namespaces = new ArrayList<String>();
        Element siteinfoElement = root.element("siteinfo");
        if (siteinfoElement == null) {
            throw new ImportFilesException("Invalid pages XML file");
        }
        Element namespacesElement = siteinfoElement.element("namespaces");
        List namespaceElements = namespacesElement.elements("namespace");
        for (Element namespaceElement : namespaceElements) {
            Attribute attribute = namespaceElement.attribute("key");
            String value = attribute.getValue();
            if (value.equals("0")) continue;
            namespaces.add(namespaceElement.getText());
        }
        return namespaces;
    }

    protected Map<String, String> readUsersFile(InputStream usersInputStream) throws IOException {
        if (usersInputStream == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> usersMap = new HashMap<String, String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(usersInputStream));
        String line = unsyncBufferedReader.readLine();
        while (line != null) {
            String[] array = StringUtil.split((String)line);
            if (array.length == 2 && Validator.isNotNull((String)array[0]) && Validator.isNotNull((String)array[1])) {
                usersMap.put(array[0], array[1]);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)("Ignoring line " + line + " because it does not contain exactly 2 columns"));
            }
            line = unsyncBufferedReader.readLine();
        }
        return usersMap;
    }
}

