/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.struts.StrutsActionPortletURL;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.wiki.DuplicatePageException;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.PageTitleException;
import com.liferay.portlet.wiki.PageVersionException;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPageAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        WikiPage page = null;
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                page = this.updatePage(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deletePage(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deletePage(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restorePage(actionRequest);
            } else if (cmd.equals("revert")) {
                this.revertPage(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribePage(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribePage(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
                if (page != null) {
                    if (workflowAction == 2) {
                        redirect = this.getSaveAndContinueRedirect(actionRequest, actionResponse, page, redirect);
                    } else if (redirect.endsWith("title=")) {
                        redirect = String.valueOf(redirect) + page.getTitle();
                    }
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchNodeException || e2 instanceof NoSuchPageException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.wiki.error");
            }
            if (e2 instanceof DuplicatePageException || e2 instanceof PageContentException || e2 instanceof PageVersionException || e2 instanceof PageTitleException || e2 instanceof SanitizerException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof AssetCategoryException || e2 instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            Throwable cause = e2.getCause();
            if (cause instanceof SanitizerException) {
                SessionErrors.add((PortletRequest)actionRequest, SanitizerException.class);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        block4: {
            try {
                ActionUtil.getNode((PortletRequest)renderRequest);
                if (!SessionErrors.contains((PortletRequest)renderRequest, (String)DuplicatePageException.class.getName())) {
                    this.getPage(renderRequest);
                }
            }
            catch (Exception e2) {
                if (e2 instanceof NoSuchNodeException || e2 instanceof PageTitleException || e2 instanceof PrincipalException) {
                    SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                    return actionMapping.findForward("portlet.wiki.error");
                }
                if (e2 instanceof NoSuchPageException) break block4;
                throw e2;
            }
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.wiki.edit_page"));
    }

    protected void deletePage(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
        WikiPage wikiPage = null;
        if (moveToTrash) {
            wikiPage = version > 0.0 ? WikiPageServiceUtil.movePageToTrash((long)nodeId, (String)title, (double)version) : WikiPageServiceUtil.movePageToTrash((long)nodeId, (String)title);
        } else if (version > 0.0) {
            WikiPageServiceUtil.discardDraft((long)nodeId, (String)title, (double)version);
        } else {
            WikiPageServiceUtil.deletePage((long)nodeId, (String)title);
        }
        if (moveToTrash && wikiPage != null) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            data.put("deleteEntryClassName", new String[]{WikiPage.class.getName()});
            data.put("deleteEntryTitle", new String[]{TrashUtil.getOriginalTitle((String)wikiPage.getTitle())});
            data.put("restoreEntryIds", new String[]{String.valueOf(wikiPage.getResourcePrimKey())});
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".deleteSuccessData"), data);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void getPage(RenderRequest renderRequest) throws Exception {
        WikiPage page;
        boolean removeRedirect;
        block8: {
            WikiNode node;
            long nodeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"nodeId");
            String title = ParamUtil.getString((PortletRequest)renderRequest, (String)"title");
            double version = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"version");
            removeRedirect = ParamUtil.getBoolean((PortletRequest)renderRequest, (String)"removeRedirect");
            if (nodeId == 0L && (node = (WikiNode)renderRequest.getAttribute("WIKI_NODE")) != null) {
                nodeId = node.getNodeId();
            }
            page = null;
            if (Validator.isNull((String)title)) {
                renderRequest.setAttribute("WIKI_PAGE", page);
                return;
            }
            try {
                page = version == 0.0 ? WikiPageServiceUtil.getPage((long)nodeId, (String)title, null) : WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)version);
            }
            catch (NoSuchPageException noSuchPageException) {
                try {
                    page = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (Boolean)false);
                }
                catch (NoSuchPageException nspe2) {
                    if (title.equals(WikiPageConstants.FRONT_PAGE) && version == 0.0) {
                        ServiceContext serviceContext = new ServiceContext();
                        page = WikiPageServiceUtil.addPage((long)nodeId, (String)title, null, (String)"New", (boolean)true, (ServiceContext)serviceContext);
                        break block8;
                    }
                    throw nspe2;
                }
            }
        }
        if (removeRedirect) {
            page.setContent("");
            page.setRedirectTitle("");
        }
        renderRequest.setAttribute("WIKI_PAGE", (Object)page);
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, ActionResponse actionResponse, WikiPage page, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        String originalRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"originalRedirect");
        StrutsActionPortletURL portletURL = new StrutsActionPortletURL((PortletResponseImpl)actionResponse, themeDisplay.getPlid(), "RENDER_PHASE");
        ((PortletURLImpl)portletURL).setParameter("struts_action", "/wiki/edit_page");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("originalRedirect", originalRedirect, false);
        portletURL.setParameter("groupId", String.valueOf(layout.getGroupId()), false);
        portletURL.setParameter("nodeId", String.valueOf(page.getNodeId()), false);
        portletURL.setParameter("title", page.getTitle(), false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void restorePage(ActionRequest actionRequest) throws Exception {
        long[] restoreEntryIds;
        long[] lArray = restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreEntryIds"), (long)0L);
        int n = restoreEntryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long restoreEntryId = lArray[n2];
            WikiPageServiceUtil.restorePageFromTrash((long)restoreEntryId);
            ++n2;
        }
    }

    protected void revertPage(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiPage.class.getName(), (PortletRequest)actionRequest);
        WikiPageServiceUtil.revertPage((long)nodeId, (String)title, (double)version, (ServiceContext)serviceContext);
    }

    protected void subscribePage(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        WikiPageServiceUtil.subscribePage((long)nodeId, (String)title);
    }

    protected void unsubscribePage(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        WikiPageServiceUtil.unsubscribePage((long)nodeId, (String)title);
    }

    protected WikiPage updatePage(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        String summary = ParamUtil.getString((PortletRequest)actionRequest, (String)"summary");
        boolean minorEdit = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"minorEdit");
        String format = ParamUtil.getString((PortletRequest)actionRequest, (String)"format");
        String parentTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"parentTitle");
        String redirectTitle = null;
        boolean copyPageAttachments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"copyPageAttachments");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiPage.class.getName(), (PortletRequest)actionRequest);
        WikiPage page = null;
        if (cmd.equals("update")) {
            page = WikiPageServiceUtil.updatePage((long)nodeId, (String)title, (double)version, (String)content, (String)summary, (boolean)minorEdit, (String)format, (String)parentTitle, redirectTitle, (ServiceContext)serviceContext);
        } else {
            page = WikiPageServiceUtil.addPage((long)nodeId, (String)title, (String)content, (String)summary, (boolean)minorEdit, (String)format, (String)parentTitle, redirectTitle, (ServiceContext)serviceContext);
            if (copyPageAttachments) {
                long templateNodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"templateNodeId");
                String templateTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"templateTitle");
                WikiPageServiceUtil.copyPageAttachments((long)templateNodeId, (String)templateTitle, (long)page.getNodeId(), (String)page.getTitle());
            }
        }
        return page;
    }
}

