/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki;

import com.liferay.portal.kernel.portlet.DefaultFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;

public class WikiFriendlyURLMapper
extends DefaultFriendlyURLMapper {
    private static final String[] _ESCAPED_CHARS = new String[]{"<PLUS>", "<QUESTION>", "<SLASH>"};
    private static final String[] _UNESCAPED_CHARS = new String[]{"+", "?", "/"};

    public String buildPath(LiferayPortletURL liferayPortletURL) {
        HashMap<String, String> routeParameters = new HashMap<String, String>();
        this.buildRouteParameters(liferayPortletURL, routeParameters);
        this.addParameter(routeParameters, "nodeName", true);
        this.addParameter(routeParameters, "title", true);
        String friendlyURLPath = this.router.parametersToUrl(routeParameters);
        if (Validator.isNull((String)friendlyURLPath)) {
            return null;
        }
        this.addParametersIncludedInPath(liferayPortletURL, routeParameters);
        friendlyURLPath = "/".concat(this.getMapping()).concat(friendlyURLPath);
        return friendlyURLPath;
    }

    protected void addParameter(Map<String, String> routeParameters, String name, boolean escape) {
        if (!routeParameters.containsKey(name)) {
            return;
        }
        String value = routeParameters.get(name);
        value = escape ? StringUtil.replace((String)value, (String[])_UNESCAPED_CHARS, (String[])_ESCAPED_CHARS) : StringUtil.replace((String)value, (String[])_ESCAPED_CHARS, (String[])_UNESCAPED_CHARS);
        routeParameters.put(name, value);
    }

    protected void populateParams(Map<String, String[]> parameterMap, String namespace, Map<String, String> routeParameters) {
        this.addParameter(routeParameters, "nodeName", false);
        this.addParameter(routeParameters, "title", false);
        super.populateParams(parameterMap, namespace, routeParameters);
    }
}

