/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.PasswordPolicyRel;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.Website;
import com.liferay.portal.service.AddressLocalServiceUtil;
import com.liferay.portal.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrgLaborLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PasswordPolicyLocalServiceUtil;
import com.liferay.portal.service.PasswordPolicyRelLocalServiceUtil;
import com.liferay.portal.service.PhoneLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.WebsiteLocalServiceUtil;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OrganizationStagedModelDataHandler
extends BaseStagedModelDataHandler<Organization> {
    public static final String[] CLASS_NAMES = new String[]{Organization.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Organization organization = OrganizationLocalServiceUtil.fetchOrganizationByUuidAndCompanyId((String)uuid, (long)group.getCompanyId());
        if (organization != null) {
            OrganizationLocalServiceUtil.deleteOrganization((Organization)organization);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Organization organization) {
        return organization.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Organization organization) throws Exception {
        LinkedList<Organization> organizations = new LinkedList<Organization>();
        organizations.add(organization);
        while (!organizations.isEmpty()) {
            Organization exportedOrganization = (Organization)organizations.remove();
            Element organizationElement = portletDataContext.getExportDataElement((ClassedModel)exportedOrganization);
            this.exportAddresses(portletDataContext, exportedOrganization, organizationElement);
            this.exportEmailAddresses(portletDataContext, exportedOrganization, organizationElement);
            this.exportOrgLabors(portletDataContext, exportedOrganization);
            this.exportPasswordPolicyRel(portletDataContext, exportedOrganization, organizationElement);
            this.exportPhones(portletDataContext, exportedOrganization, organizationElement);
            this.exportWebsites(portletDataContext, exportedOrganization, organizationElement);
            portletDataContext.addClassedModel(organizationElement, ExportImportPathUtil.getModelPath((StagedModel)exportedOrganization), (ClassedModel)exportedOrganization);
            organizations.addAll(exportedOrganization.getSuborganizations());
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Organization organization) throws Exception {
        long userId = portletDataContext.getUserId(organization.getUserUuid());
        Map organizationIds = portletDataContext.getNewPrimaryKeysMap(Organization.class);
        long parentOrganizationId = MapUtil.getLong((Map)organizationIds, (long)organization.getParentOrganizationId(), (long)organization.getParentOrganizationId());
        if (parentOrganizationId != 0L && parentOrganizationId == organization.getParentOrganizationId()) {
            String parentOrganizationPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)Organization.class.getName(), (long)parentOrganizationId);
            Organization parentOrganization = (Organization)portletDataContext.getZipEntryAsObject(parentOrganizationPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)parentOrganization);
            parentOrganizationId = MapUtil.getLong((Map)organizationIds, (long)organization.getParentOrganizationId(), (long)organization.getParentOrganizationId());
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)organization);
        serviceContext.setUserId(userId);
        Organization existingOrganization = OrganizationLocalServiceUtil.fetchOrganizationByUuidAndCompanyId((String)organization.getUuid(), (long)portletDataContext.getCompanyId());
        if (existingOrganization == null) {
            existingOrganization = OrganizationLocalServiceUtil.fetchOrganization((long)portletDataContext.getCompanyId(), (String)organization.getName());
        }
        Organization importedOrganization = null;
        if (existingOrganization == null) {
            serviceContext.setUuid(organization.getUuid());
            importedOrganization = OrganizationLocalServiceUtil.addOrganization((long)userId, (long)parentOrganizationId, (String)organization.getName(), (String)organization.getType(), (long)organization.getRegionId(), (long)organization.getCountryId(), (int)organization.getStatusId(), (String)organization.getComments(), (boolean)false, (ServiceContext)serviceContext);
        } else {
            importedOrganization = OrganizationLocalServiceUtil.updateOrganization((long)portletDataContext.getCompanyId(), (long)existingOrganization.getOrganizationId(), (long)parentOrganizationId, (String)organization.getName(), (String)organization.getType(), (long)organization.getRegionId(), (long)organization.getCountryId(), (int)organization.getStatusId(), (String)organization.getComments(), (boolean)false, (ServiceContext)serviceContext);
        }
        this.importAddresses(portletDataContext, organization, importedOrganization);
        this.importEmailAddresses(portletDataContext, organization, importedOrganization);
        this.importOrgLabors(portletDataContext, organization, importedOrganization);
        this.importPasswordPolicyRel(portletDataContext, organization, importedOrganization);
        this.importPhones(portletDataContext, organization, importedOrganization);
        this.importWebsites(portletDataContext, organization, importedOrganization);
        portletDataContext.importClassedModel((ClassedModel)organization, (ClassedModel)importedOrganization);
    }

    protected void exportAddresses(PortletDataContext portletDataContext, Organization organization, Element organizationElement) throws PortalException, SystemException {
        List addresses = AddressLocalServiceUtil.getAddresses((long)organization.getCompanyId(), (String)organization.getModelClassName(), (long)organization.getOrganizationId());
        for (Address address : addresses) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)address, (String)"embedded");
        }
    }

    protected void exportEmailAddresses(PortletDataContext portletDataContext, Organization organization, Element organizationElement) throws PortalException, SystemException {
        List emailAddresses = EmailAddressLocalServiceUtil.getEmailAddresses((long)organization.getCompanyId(), (String)organization.getModelClassName(), (long)organization.getOrganizationId());
        for (EmailAddress emailAddress : emailAddresses) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)emailAddress, (String)"embedded");
        }
    }

    protected void exportOrgLabors(PortletDataContext portletDataContext, Organization organization) throws SystemException {
        List orgLabors = OrgLaborLocalServiceUtil.getOrgLabors((long)organization.getOrganizationId());
        String path = ExportImportPathUtil.getModelPath((StagedModel)organization, (String)OrgLabor.class.getSimpleName());
        portletDataContext.addZipEntry(path, (Object)orgLabors);
    }

    protected void exportPasswordPolicyRel(PortletDataContext portletDataContext, Organization organization, Element organizationElement) throws PortalException, SystemException {
        PasswordPolicyRel passwordPolicyRel = PasswordPolicyRelLocalServiceUtil.fetchPasswordPolicyRel((String)Organization.class.getName(), (long)organization.getOrganizationId());
        if (passwordPolicyRel == null) {
            return;
        }
        PasswordPolicy passwordPolicy = PasswordPolicyLocalServiceUtil.getPasswordPolicy((long)passwordPolicyRel.getPasswordPolicyId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)passwordPolicy, (String)"strong");
    }

    protected void exportPhones(PortletDataContext portletDataContext, Organization organization, Element organizationElement) throws PortalException, SystemException {
        List phones = PhoneLocalServiceUtil.getPhones((long)organization.getCompanyId(), (String)organization.getModelClassName(), (long)organization.getOrganizationId());
        for (Phone phone : phones) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)phone, (String)"embedded");
        }
    }

    protected void exportWebsites(PortletDataContext portletDataContext, Organization organization, Element organizationElement) throws PortalException, SystemException {
        List websites = WebsiteLocalServiceUtil.getWebsites((long)organization.getCompanyId(), (String)organization.getModelClassName(), (long)organization.getOrganizationId());
        for (Website website : websites) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)website, (String)"embedded");
        }
    }

    protected void importAddresses(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException, SystemException {
        List addressElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Address.class);
        ArrayList<Address> addresses = new ArrayList<Address>(addressElements.size());
        for (Element addressElement : addressElements) {
            String addressPath = addressElement.attributeValue("path");
            Address address = (Address)portletDataContext.getZipEntryAsObject(addressPath);
            address.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)address);
            Map addressIds = portletDataContext.getNewPrimaryKeysMap(Address.class);
            long addressId = (Long)addressIds.get(address.getPrimaryKey());
            address.setAddressId(addressId);
            addresses.add(address);
        }
        UsersAdminUtil.updateAddresses((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), addresses);
    }

    protected void importEmailAddresses(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException, SystemException {
        List emailAddressElements = portletDataContext.getReferenceDataElements((StagedModel)organization, EmailAddress.class);
        ArrayList<EmailAddress> emailAddresses = new ArrayList<EmailAddress>(emailAddressElements.size());
        for (Element emailAddressElement : emailAddressElements) {
            String emailAddressPath = emailAddressElement.attributeValue("path");
            EmailAddress emailAddress = (EmailAddress)portletDataContext.getZipEntryAsObject(emailAddressPath);
            emailAddress.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)emailAddress);
            Map emailAddressIds = portletDataContext.getNewPrimaryKeysMap(EmailAddress.class);
            long emailAddressId = (Long)emailAddressIds.get(emailAddress.getPrimaryKey());
            emailAddress.setEmailAddressId(emailAddressId);
            emailAddresses.add(emailAddress);
        }
        UsersAdminUtil.updateEmailAddresses((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), emailAddresses);
    }

    protected void importOrgLabors(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException, SystemException {
        String path = ExportImportPathUtil.getModelPath((StagedModel)organization, (String)OrgLabor.class.getSimpleName());
        List orgLabors = (List)portletDataContext.getZipEntryAsObject(path);
        for (OrgLabor orgLabor : orgLabors) {
            orgLabor.setOrgLaborId(0L);
        }
        UsersAdminUtil.updateOrgLabors((long)importedOrganization.getOrganizationId(), (List)orgLabors);
    }

    protected void importPasswordPolicyRel(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException, SystemException {
        List passwordPolicyElements = portletDataContext.getReferenceDataElements((StagedModel)organization, PasswordPolicy.class);
        if (passwordPolicyElements.isEmpty()) {
            return;
        }
        Element passwordPolicyElement = (Element)passwordPolicyElements.get(0);
        String passwordPolicyPath = passwordPolicyElement.attributeValue("path");
        PasswordPolicy passwordPolicy = (PasswordPolicy)portletDataContext.getZipEntryAsObject(passwordPolicyPath);
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)passwordPolicy);
        Map passwordPolicyIds = portletDataContext.getNewPrimaryKeysMap(PasswordPolicy.class);
        long passwordPolicyId = (Long)passwordPolicyIds.get(passwordPolicy.getPrimaryKey());
        OrganizationLocalServiceUtil.addPasswordPolicyOrganizations((long)passwordPolicyId, (long[])new long[]{importedOrganization.getOrganizationId()});
    }

    protected void importPhones(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException, SystemException {
        List phoneElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Phone.class);
        ArrayList<Phone> phones = new ArrayList<Phone>(phoneElements.size());
        for (Element phoneElement : phoneElements) {
            String phonePath = phoneElement.attributeValue("path");
            Phone phone = (Phone)portletDataContext.getZipEntryAsObject(phonePath);
            phone.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)phone);
            Map phoneIds = portletDataContext.getNewPrimaryKeysMap(Phone.class);
            long phoneId = (Long)phoneIds.get(phone.getPrimaryKey());
            phone.setPhoneId(phoneId);
            phones.add(phone);
        }
        UsersAdminUtil.updatePhones((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), phones);
    }

    protected void importWebsites(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws PortalException, SystemException {
        List websiteElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Website.class);
        ArrayList<Website> websites = new ArrayList<Website>(websiteElements.size());
        for (Element websiteElement : websiteElements) {
            String websitePath = websiteElement.attributeValue("path");
            Website website = (Website)portletDataContext.getZipEntryAsObject(websitePath);
            website.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)website);
            Map websiteIds = portletDataContext.getNewPrimaryKeysMap(Website.class);
            long websiteId = (Long)websiteIds.get(website.getPrimaryKey());
            website.setWebsiteId(websiteId);
            websites.add(website);
        }
        UsersAdminUtil.updateWebsites((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), websites);
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        Organization organization = OrganizationLocalServiceUtil.fetchOrganizationByUuidAndCompanyId((String)uuid, (long)companyId);
        return organization != null;
    }
}

