/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.action;

import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.model.SCLicense;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.service.SCFrameworkVersionServiceUtil;
import com.liferay.portlet.softwarecatalog.service.SCLicenseServiceUtil;
import com.liferay.portlet.softwarecatalog.service.SCProductEntryServiceUtil;
import com.liferay.portlet.softwarecatalog.service.SCProductVersionServiceUtil;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static void getFrameworkVersion(HttpServletRequest request) throws Exception {
        long frameworkVersionId = ParamUtil.getLong((HttpServletRequest)request, (String)"frameworkVersionId");
        SCFrameworkVersion frameworkVersion = null;
        if (frameworkVersionId > 0L) {
            frameworkVersion = SCFrameworkVersionServiceUtil.getFrameworkVersion((long)frameworkVersionId);
        }
        request.setAttribute("SOFTWARE_CATALOG_FRAMEWORK_VERSION", (Object)frameworkVersion);
    }

    public static void getFrameworkVersion(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFrameworkVersion(request);
    }

    public static void getLicense(HttpServletRequest request) throws Exception {
        long licenseId = ParamUtil.getLong((HttpServletRequest)request, (String)"licenseId");
        SCLicense license = null;
        if (licenseId > 0L) {
            license = SCLicenseServiceUtil.getLicense((long)licenseId);
        }
        request.setAttribute("SOFTWARE_CATALOG_LICENSE", (Object)license);
    }

    public static void getLicense(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getLicense(request);
    }

    public static void getProductEntry(HttpServletRequest request) throws Exception {
        long productEntryId = ParamUtil.getLong((HttpServletRequest)request, (String)"productEntryId");
        SCProductEntry productEntry = null;
        if (productEntryId > 0L) {
            productEntry = SCProductEntryServiceUtil.getProductEntry((long)productEntryId);
        }
        request.setAttribute("SOFTWARE_CATALOG_PRODUCT_ENTRY", (Object)productEntry);
    }

    public static void getProductEntry(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getProductEntry(request);
    }

    public static void getProductVersion(HttpServletRequest request) throws Exception {
        long productVersionId = ParamUtil.getLong((HttpServletRequest)request, (String)"productVersionId");
        long copyProductVersionId = ParamUtil.getLong((HttpServletRequest)request, (String)"copyProductVersionId");
        SCProductVersion productVersion = null;
        SCProductEntry productEntry = null;
        if (productVersionId > 0L) {
            productVersion = SCProductVersionServiceUtil.getProductVersion((long)productVersionId);
            productEntry = SCProductEntryServiceUtil.getProductEntry((long)productVersion.getProductEntryId());
            request.setAttribute("SOFTWARE_CATALOG_PRODUCT_VERSION", (Object)productVersion);
            request.setAttribute("SOFTWARE_CATALOG_PRODUCT_ENTRY", (Object)productEntry);
        } else if (copyProductVersionId > 0L) {
            productVersion = SCProductVersionServiceUtil.getProductVersion((long)copyProductVersionId);
            productEntry = SCProductEntryServiceUtil.getProductEntry((long)productVersion.getProductEntryId());
            String oldVersion = productVersion.getVersion();
            Version version = Version.getInstance((String)oldVersion);
            version = Version.incrementBuildNumber((Version)version);
            String newVersion = version.toString();
            productVersion.setVersion(newVersion);
            String directDownloadURL = productVersion.getDirectDownloadURL();
            directDownloadURL = StringUtil.replace((String)directDownloadURL, (String)oldVersion, (String)newVersion);
            productVersion.setDirectDownloadURL(directDownloadURL);
            request.setAttribute("SOFTWARE_CATALOG_PRODUCT_VERSION", (Object)productVersion);
            request.setAttribute("SOFTWARE_CATALOG_PRODUCT_ENTRY", (Object)productEntry);
        } else {
            ActionUtil.getProductEntry(request);
        }
    }

    public static void getProductVersion(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getProductVersion(request);
    }
}

